/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.layout;

import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.RenderComponent;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class PositionedComponent<T extends RenderComponent>
implements Renderable,
GuiEventListener,
NarratableEntry {
    private final T component;
    private int x;
    private int y;
    private final AnchorPoint windowAnchor;
    private final int offsetX;
    private final int offsetY;
    private final AnchorPoint origin;

    public PositionedComponent(T component, AnchorPoint windowAnchor, int offsetX, int offsetY, AnchorPoint origin) {
        this.component = component;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.windowAnchor = windowAnchor;
        this.origin = origin;
    }

    public void updatePosition(int windowWidth, int windowHeight) {
        Vector2ic componentSize = this.component.size();
        Vector2i windowPosition = this.windowAnchor.getAnchorPosition(windowWidth, windowHeight);
        Vector2i anchoredPosition = this.origin.getAnchorPosition(componentSize.x(), componentSize.y());
        this.x = windowPosition.x() + this.offsetX - anchoredPosition.x();
        this.y = windowPosition.y() + this.offsetY - anchoredPosition.y();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderComponent(graphics, delta);
    }

    public void renderComponent(GuiGraphics graphics, float deltaTime) {
        this.component.render(graphics, this.x, this.y, deltaTime);
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public T getComponent() {
        return this.component;
    }

    public void m_93692_(boolean focused) {
    }

    public boolean m_93696_() {
        return false;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput builder) {
    }
}

