/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.bind.RadialIcon;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.haptic.HapticEffects;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.gui.guide.GuideAction;
import dev.isxander.controlify.gui.guide.GuideActionRenderer;
import dev.isxander.controlify.gui.layout.AnchorPoint;
import dev.isxander.controlify.gui.layout.PositionedComponent;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.ScreenProcessorProvider;
import dev.isxander.controlify.sound.ControlifyClientSounds;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.virtualmouse.VirtualMouseBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class RadialMenuScreen
extends Screen
implements ScreenControllerEventListener,
ScreenProcessorProvider {
    public static final ResourceLocation EMPTY_ACTION = CUtil.rl("empty_action");
    private final ControllerEntity controller;
    @Nullable
    private final EditMode editMode;
    private final Screen parent;
    private final Component text;
    private final RadialItem[] items;
    private final RadialButton[] buttons;
    private float radialRadius;
    private final InputBinding openBind;
    private int selectedButton = -1;
    private int idleTicks;
    private final int idleTicksTimeout;
    private boolean isEditing;
    private ActionSelectList actionSelectList;
    private final Processor processor = new Processor(this);

    public RadialMenuScreen(ControllerEntity controller, InputBinding openBind, RadialItem[] items, Component text, @Nullable EditMode editMode, Screen parent) {
        super(text);
        this.text = text;
        this.controller = controller;
        this.items = items;
        this.buttons = new RadialButton[items.length];
        this.editMode = editMode;
        this.parent = parent;
        this.idleTicksTimeout = ((InputComponent.Config)controller.input().orElseThrow().confObj()).radialButtonFocusTimeoutTicks;
        this.openBind = openBind;
    }

    protected void m_7856_() {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        float buttonRadius = (float)Math.sqrt(2048.0) + 8.0f;
        float circumference = buttonRadius * (float)this.items.length;
        this.radialRadius = Math.max(circumference / ((float)Math.PI * 2), 43.0f);
        Animation animation = Animation.of(5).easing(EasingFunction.EASE_OUT_QUAD);
        for (int i = 0; i < this.items.length; ++i) {
            float angle = (float)Math.PI * 2 * (float)i / (float)this.items.length - 1.5707964f;
            float x = (float)centerX + Mth.m_14089_((float)angle) * this.radialRadius;
            float y = (float)centerY + Mth.m_14031_((float)angle) * this.radialRadius;
            RadialButton button = this.buttons[i] = new RadialButton(this.items[i], centerX - 16, centerY - 16);
            animation.consumerF(button::setX, centerX - 16, x - 16.0f).consumerF(button::setY, centerY - 16, y - 16.0f);
            this.m_142416_(button);
        }
        animation.play();
        if (this.editMode != null) {
            PositionedComponent exitGuide = (PositionedComponent)this.m_142416_(new PositionedComponent<GuideActionRenderer<Object>>(new GuideActionRenderer<Object>(new GuideAction<Object>(ControlifyBindings.GUI_BACK.on(this.controller), obj -> Optional.of(CommonComponents.f_130655_)), false, true), AnchorPoint.BOTTOM_CENTER, 0, -10, AnchorPoint.BOTTOM_CENTER));
            ((GuideActionRenderer)exitGuide.getComponent()).updateName(null);
            exitGuide.updatePosition(this.f_96543_, this.f_96544_);
        }
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        if (this.controller != controller) {
            return;
        }
        if (this.editMode == null && !this.openBind.digitalNow()) {
            if (this.selectedButton != -1 && this.buttons[this.selectedButton].invoke()) {
                this.playClickSound();
            }
            this.m_7379_();
        }
        if (this.editMode != null && ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
            this.playClickSound();
            this.m_7379_();
        }
        if (!this.isEditing) {
            float x = ControlifyBindings.RADIAL_AXIS_RIGHT.on(controller).analogueNow() - ControlifyBindings.RADIAL_AXIS_LEFT.on(controller).analogueNow();
            float y = ControlifyBindings.RADIAL_AXIS_DOWN.on(controller).analogueNow() - ControlifyBindings.RADIAL_AXIS_UP.on(controller).analogueNow();
            float threshold = controller.input().orElseThrow().config().config().buttonActivationThreshold;
            if (Math.abs(x) >= threshold || Math.abs(y) >= threshold) {
                float each;
                float angle = Mth.m_14177_((float)(57.295776f * (float)Mth.m_14136_((double)y, (double)x) - 90.0f)) + 180.0f;
                int newSelected = Mth.m_14143_((float)((angle + (each = 360.0f / (float)this.buttons.length) / 2.0f) / each)) % this.buttons.length;
                if (newSelected != this.selectedButton) {
                    this.selectedButton = newSelected;
                    this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ControlifyClientSounds.SCREEN_FOCUS_CHANGE.get(), (float)1.0f));
                    controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
                }
                for (int i = 0; i < this.buttons.length; ++i) {
                    boolean selected = i == this.selectedButton;
                    this.buttons[i].m_93692_(selected);
                    if (!selected) continue;
                    this.m_7522_(this.buttons[i]);
                }
                this.idleTicks = 0;
            } else if (this.editMode == null) {
                ++this.idleTicks;
                if (this.idleTicks >= this.idleTicksTimeout && this.selectedButton != -1) {
                    this.selectedButton = -1;
                    for (RadialButton button : this.buttons) {
                        button.m_93692_(false);
                    }
                    controller.hdHaptics().ifPresent(haptics -> haptics.playHaptic(HapticEffects.NAVIGATE));
                }
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.editMode != null) {
            this.m_280039_(graphics);
        }
        super.m_88315_(graphics, mouseX, mouseY, delta);
        if (this.editMode == null) {
            graphics.m_280653_(this.f_96547_, this.text, this.f_96543_ / 2, this.f_96544_ - 39, -1);
        }
    }

    private void playClickSound() {
        this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    private void finishEditing() {
        this.isEditing = false;
        this.m_169411_((GuiEventListener)this.actionSelectList);
        this.m_7522_(null);
        this.actionSelectList = null;
    }

    public void m_7379_() {
        Controlify.instance().config().saveIfDirty();
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return this.editMode != null;
    }

    @Override
    public ScreenProcessor<?> screenProcessor() {
        return this.processor;
    }

    public static class Processor
    extends ScreenProcessor<RadialMenuScreen> {
        public Processor(RadialMenuScreen screen) {
            super(screen);
        }

        @Override
        public VirtualMouseBehaviour virtualMouseBehaviour() {
            return VirtualMouseBehaviour.DISABLED;
        }
    }

    public static interface RadialItem {
        public Component name();

        public RadialIcon icon();

        public boolean playAction();
    }

    public class RadialButton
    implements Renderable,
    GuiEventListener,
    NarratableEntry,
    ComponentProcessor {
        public static final ResourceLocation TEXTURE = CUtil.rl("textures/gui/radial-buttons.png");
        private int x;
        private int y;
        private float translateX;
        private float translateY;
        private boolean focused;
        private RadialItem item;
        private MultiLineLabel name;

        private RadialButton(RadialItem item, float x, float y) {
            this.setX(x);
            this.setY(y);
            this.setAction(item);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)this.x + this.translateX, (float)this.y + this.translateY, 0.0f);
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
            Blit.blitTex(graphics, TEXTURE, 0, 0, this.focused ? 16 : 0, 0, 16, 16, 32, 16);
            graphics.m_280168_().m_85849_();
            if (RadialMenuScreen.this.editMode == null || !this.focused) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(4.0f, 4.0f, 0.0f);
                graphics.m_280168_().m_85841_(1.5f, 1.5f, 1.0f);
                this.item.icon().draw(graphics, 0, 0, delta);
                graphics.m_280168_().m_85849_();
            } else {
                Component bind = ControlifyBindings.GUI_PRESS.on(RadialMenuScreen.this.controller).inputIcon();
                Font font = RadialMenuScreen.this.f_96547_;
                int n = 16 - RadialMenuScreen.this.f_96547_.m_92852_((FormattedText)bind) / 2;
                Objects.requireNonNull(RadialMenuScreen.this.f_96547_);
                graphics.m_280430_(font, bind, n, 16 - 9 / 2, -1);
            }
            graphics.m_280168_().m_85849_();
            if (this.focused) {
                int n = RadialMenuScreen.this.f_96543_ / 2;
                int n2 = RadialMenuScreen.this.f_96544_ / 2;
                Objects.requireNonNull(RadialMenuScreen.this.f_96547_);
                int n3 = n2 - 9 / 2;
                int n4 = this.name.m_5770_() - 1;
                Objects.requireNonNull(RadialMenuScreen.this.f_96547_);
                this.name.m_6276_(graphics, n, n3 - n4 * 9 / 2);
            }
        }

        public boolean invoke() {
            return this.item.playAction();
        }

        public void setAction(RadialItem item) {
            this.item = item;
            this.name = MultiLineLabel.m_94341_((Font)RadialMenuScreen.this.f_96547_, (FormattedText)item.name(), (int)((int)(RadialMenuScreen.this.radialRadius * 2.0f - 32.0f)));
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public void setX(float x) {
            this.x = (int)x;
            this.translateX = x - (float)this.x;
        }

        public void setY(float y) {
            this.y = (int)y;
            this.translateY = y - (float)this.y;
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (RadialMenuScreen.this.editMode != null && controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                RadialButton button = RadialMenuScreen.this.buttons[RadialMenuScreen.this.selectedButton];
                int x = button.x < RadialMenuScreen.this.f_96543_ / 2 ? button.x - 110 : button.x + 42;
                RadialMenuScreen.this.actionSelectList = new ActionSelectList(RadialMenuScreen.this.selectedButton, x, button.y, 100, 80);
                RadialMenuScreen.this.m_142416_((GuiEventListener)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.m_7522_((GuiEventListener)RadialMenuScreen.this.actionSelectList);
                RadialMenuScreen.this.isEditing = true;
                return true;
            }
            return false;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return this.m_93696_() ? NarratableEntry.NarrationPriority.FOCUSED : NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput builder) {
            builder.m_169146_(NarratedElementType.TITLE, this.item.name());
        }

        public ScreenRectangle m_264198_() {
            return new ScreenRectangle(this.x, this.y, 32, 32);
        }
    }

    public static interface EditMode {
        public void setRadialItem(int var1, RadialItem var2);

        public List<RadialItem> getEditCandidates();
    }

    public class ActionSelectList
    implements Renderable,
    ContainerEventHandler,
    NarratableEntry,
    ComponentProcessor {
        private final int radialIndex;
        private int x;
        private int y;
        private int width;
        private int height;
        private final int itemHeight = 10;
        private int scrollOffset;
        private boolean focused;
        private ActionEntry focusedEntry;
        private final List<ActionEntry> children = new ArrayList<ActionEntry>();

        public ActionSelectList(int index, int x, int y, int width, int height) {
            this.radialIndex = index;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            for (RadialItem item : RadialMenuScreen.this.editMode.getEditCandidates()) {
                this.children.add(new ActionEntry(item));
            }
            RadialItem item = RadialMenuScreen.this.items[this.radialIndex];
            this.children.stream().filter(action -> action.item.equals(item)).findAny().ifPresent(this::m_7522_);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            graphics.m_280509_(this.x, this.y, this.x + this.width, this.y + this.height, Integer.MIN_VALUE);
            graphics.m_280588_(this.x, this.y, this.x + this.width, this.y + this.height);
            int y = this.y - this.scrollOffset;
            for (ActionEntry child : this.children) {
                child.render(graphics, this.x, y, this.width, 10, mouseX, mouseY, delta);
                y += 10;
            }
            graphics.m_280618_();
            graphics.m_280637_(this.x - 1, this.y - 1, this.width + 2, this.height + 2, -2130706433);
        }

        @Override
        public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
            if (controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
                RadialMenuScreen.this.finishEditing();
                return true;
            }
            return false;
        }

        public List<ActionEntry> m_6702_() {
            return this.children;
        }

        public boolean m_7282_() {
            return false;
        }

        public void m_7897_(boolean dragging) {
        }

        @Nullable
        public ActionEntry getFocused() {
            return this.focusedEntry;
        }

        public void m_7522_(@Nullable GuiEventListener child) {
            int index;
            ActionEntry focus;
            this.focusedEntry = focus = (ActionEntry)child;
            if (focus != null && (index = this.m_6702_().indexOf(child)) != -1) {
                int focusY = index * 10 - this.scrollOffset;
                if (focusY < 0) {
                    this.scrollOffset = Mth.m_14045_((int)(index * 10), (int)0, (int)(this.m_6702_().size() * 10 - this.height));
                } else if (focusY + 10 > this.height) {
                    this.scrollOffset = Mth.m_14045_((int)(index * 10 + 10 - this.height), (int)0, (int)(this.m_6702_().size() * 10 - this.height));
                }
            }
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        public boolean m_93696_() {
            return this.focused;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return this.focused ? NarratableEntry.NarrationPriority.FOCUSED : NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput builder) {
            if (this.getFocused() != null) {
                builder.m_169146_(NarratedElementType.TITLE, this.getFocused().item.name());
            }
        }

        public class ActionEntry
        implements GuiEventListener,
        ComponentProcessor {
            private int x;
            private int y;
            private boolean focused;
            private final RadialItem item;

            public ActionEntry(RadialItem item) {
                this.item = item;
            }

            public void render(GuiGraphics graphics, int x, int y, int width, int itemHeight, int mouseX, int mouseY, float delta) {
                this.x = x;
                this.y = y;
                if (this.focused) {
                    graphics.m_280509_(x, y, x + width, y + itemHeight, -16777216);
                }
                graphics.m_280430_(RadialMenuScreen.this.f_96547_, this.item.name(), x + 2, y + 1, this.focused ? -1 : -5855578);
            }

            public void m_93692_(boolean focused) {
                this.focused = focused;
            }

            public boolean m_93696_() {
                return this.focused;
            }

            @Nullable
            public ComponentPath m_264064_(FocusNavigationEvent event) {
                return !this.focused ? ComponentPath.m_264401_((GuiEventListener)this) : null;
            }

            public ScreenRectangle m_264198_() {
                return new ScreenRectangle(this.x, this.y, ActionSelectList.this.width, 10);
            }

            @Override
            public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
                if (controller == RadialMenuScreen.this.controller && ControlifyBindings.GUI_PRESS.on(controller).justPressed()) {
                    RadialMenuScreen.this.editMode.setRadialItem(ActionSelectList.this.radialIndex, this.item);
                    Controlify.instance().config().setDirty();
                    RadialMenuScreen.this.buttons[ActionSelectList.this.radialIndex].setAction(this.item);
                    RadialMenuScreen.this.playClickSound();
                    RadialMenuScreen.this.finishEditing();
                    return true;
                }
                return false;
            }
        }
    }
}

