/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.gui.screen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.id.ControllerType;
import dev.isxander.controlify.gui.screen.DontInteruptScreen;
import dev.isxander.controlify.hid.HIDDevice;
import dev.isxander.controlify.platform.main.PlatformMainUtil;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.ClientUtils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class SubmitUnknownControllerScreen
extends Screen
implements DontInteruptScreen {
    public static final String SUBMISSION_URL = "https://api-controlify.isxander.dev/api/v1/submit";
    public static final Pattern NAME_PATTERN = Pattern.compile("^[\\w\\- ]{3,64}$");
    private final ControllerEntity controller;
    private Checkbox operationalCheckbox;
    private final Screen lastScreen;
    private boolean invalidName;
    private Button submitButton;
    private EditBox nameField;

    public SubmitUnknownControllerScreen(ControllerEntity controller, Screen lastScreen) {
        super((Component)Component.m_237115_((String)"controlify.controller_submission.title").m_130940_(ChatFormatting.BOLD));
        if (!SubmitUnknownControllerScreen.canSubmit(controller)) {
            throw new IllegalArgumentException("Controller ineligible for submission!");
        }
        this.controller = controller;
        this.lastScreen = lastScreen;
    }

    protected void m_7856_() {
        MultiLineTextWidget content = (MultiLineTextWidget)this.m_142416_((GuiEventListener)new MultiLineTextWidget((Component)Component.m_237115_((String)"controlify.controller_submission.message"), this.f_96547_));
        content.m_269098_(this.f_96543_ - 100);
        content.m_252865_(this.f_96543_ / 2 - content.m_5711_() / 2);
        int titleBottomPadding = 11;
        int checkboxPadding = 6;
        int checkboxHeight = 20;
        int buttonHeight = 20;
        int nameFieldPaddingTop = 5;
        int nameFieldHeight = 20;
        int errorPadding = 4;
        Objects.requireNonNull(this.f_96547_);
        int n = 9 + titleBottomPadding + content.m_93694_() + checkboxPadding + checkboxHeight + checkboxPadding + buttonHeight + nameFieldPaddingTop + nameFieldHeight + errorPadding;
        Objects.requireNonNull(this.f_96547_);
        int allHeight = n + 9;
        int y = this.f_96544_ / 2 - allHeight / 2;
        this.m_142416_((GuiEventListener)ClientUtils.createStringWidget(this.m_96636_(), this.f_96547_, 25, y));
        Objects.requireNonNull(this.f_96547_);
        content.m_253211_(y += 9 + titleBottomPadding);
        MutableComponent operationalText = Component.m_237115_((String)"controlify.controller_submission.operational_checkbox").m_130940_(ChatFormatting.BOLD);
        this.operationalCheckbox = new Checkbox(this.f_96543_ / 2 - this.f_96547_.m_92852_((FormattedText)operationalText) / 2 - 8, y += content.m_93694_() + checkboxPadding, 21 + this.f_96547_.m_92852_((FormattedText)operationalText), 17, (Component)operationalText, true);
        this.m_142416_((GuiEventListener)this.operationalCheckbox);
        this.submitButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"controlify.controller_submission.submit"), this::onSubmitButton).m_252794_(this.f_96543_ / 2 - 155, y += checkboxHeight + checkboxPadding).m_252780_(150).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"controlify.controller_submission.skip"), btn -> this.m_7379_()).m_252794_(this.f_96543_ / 2 + 5, y).m_252780_(150).m_253136_());
        this.nameField = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, this.f_96543_ / 2 - 155, y += buttonHeight + nameFieldPaddingTop, 310, 20, (Component)Component.m_237115_((String)"controlify.controller_submission.name_narration")));
        this.nameField.m_257771_((Component)Component.m_237115_((String)"controlify.controller_submission.name_hint"));
        this.nameField.m_94144_(this.controller.name());
        this.nameField.m_94153_(s -> {
            this.invalidName = !this.checkValidName((String)s);
            this.submitButton.f_93623_ = !this.invalidName;
            return true;
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        if (this.invalidName) {
            graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"controlify.controller_submission.invalid_name").m_130940_(ChatFormatting.RED), this.f_96543_ / 2, this.nameField.m_264198_().m_274349_() + 4, -1);
        }
    }

    protected void onSubmitButton(Button button) {
        if (this.submit()) {
            this.dontShowAgain();
            this.m_7379_();
        } else {
            this.dontShowAgain();
            this.m_7379_();
        }
    }

    protected boolean submit() {
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(new URI(SUBMISSION_URL)).POST(HttpRequest.BodyPublishers.ofString(this.generateRequestBody())).header("Content-Type", "application/json").build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() / 100 != 2) {
                CUtil.LOGGER.error("Received non-2xx status code from '{}', got {} with body '{}'", SUBMISSION_URL, response.statusCode(), response.body());
                return false;
            }
            CUtil.LOGGER.log("Successfully sent controller information to '{}'", SUBMISSION_URL);
            return true;
        }
        catch (Exception e) {
            CUtil.LOGGER.error("Failed to submit controller to '%s'".formatted(SUBMISSION_URL), e);
            return false;
        }
    }

    private String generateRequestBody() {
        HIDDevice hid = this.controller.info().hid().orElseThrow();
        JsonObject object = new JsonObject();
        object.addProperty("vendorID", (Number)hid.vendorId());
        object.addProperty("productID", (Number)hid.productId());
        object.addProperty("GUID", this.controller.guid());
        object.addProperty("reportedName", this.nameField.m_94155_());
        object.addProperty("controlifyVersion", PlatformMainUtil.getControlifyVersion());
        object.addProperty("operational", Boolean.valueOf(this.operationalCheckbox.m_93840_()));
        Gson gson = new Gson();
        return gson.toJson((JsonElement)object);
    }

    private boolean checkValidName(String name) {
        return NAME_PATTERN.matcher(name.trim()).matches();
    }

    private void dontShowAgain() {
        this.controller.genericConfig().config().dontShowControllerSubmission = true;
        Controlify.instance().config().setDirty();
    }

    public void m_7379_() {
        this.dontShowAgain();
        Controlify.instance().config().saveIfDirty();
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public boolean m_6913_() {
        return false;
    }

    public static boolean canSubmit(ControllerEntity controller) {
        return controller.info().type() == ControllerType.DEFAULT && !controller.genericConfig().config().dontShowControllerSubmission;
    }
}

