/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.ingame;

import com.mojang.blaze3d.pipeline.RenderTarget;
import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.api.event.ControlifyEvents;
import dev.isxander.controlify.api.ingameinput.LookInputModifier;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.controller.gyro.GyroButtonMode;
import dev.isxander.controlify.controller.gyro.GyroComponent;
import dev.isxander.controlify.controller.gyro.GyroState;
import dev.isxander.controlify.controller.gyro.GyroYawMode;
import dev.isxander.controlify.controller.input.InputComponent;
import dev.isxander.controlify.driver.steamdeck.SteamDeckDriver;
import dev.isxander.controlify.gui.screen.RadialItems;
import dev.isxander.controlify.gui.screen.RadialMenuScreen;
import dev.isxander.controlify.ingame.ControllerPlayerMovement;
import dev.isxander.controlify.ingame.PickBlockAccessor;
import dev.isxander.controlify.mixins.feature.steamdeck.ScreenshotAccessor;
import dev.isxander.controlify.server.ServerPolicies;
import dev.isxander.controlify.utils.ControllerUtils;
import dev.isxander.controlify.utils.DebugOverlayHelper;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.animation.api.Animation;
import dev.isxander.controlify.utils.animation.api.EasingFunction;
import java.io.File;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class InGameInputHandler {
    private final ControllerEntity controller;
    private final Controlify controlify;
    private final Minecraft minecraft;
    private double lookInputX;
    private double lookInputY;
    private final GyroState gyroInput = new GyroState();
    private boolean gyroToggledOn;
    private boolean wasAiming;
    private Animation flickAnimation;
    private boolean shouldShowPlayerList;
    private final HoldRepeatHelper dropRepeatHelper;
    private boolean dropRepeating;
    private final HoldRepeatHelper hotbarNextRepeatHelper;
    private final HoldRepeatHelper hotbarPrevRepeatHelper;

    public InGameInputHandler(ControllerEntity controller) {
        this.controller = controller;
        this.minecraft = Minecraft.m_91087_();
        this.controlify = Controlify.instance();
        this.dropRepeatHelper = new HoldRepeatHelper(20, 1);
        this.hotbarNextRepeatHelper = new HoldRepeatHelper(10, 4);
        this.hotbarPrevRepeatHelper = new HoldRepeatHelper(10, 4);
        this.gyroToggledOn = false;
    }

    public void inputTick() {
        boolean isController = ControllerPlayerMovement.shouldBeControllerInput();
        this.handlePlayerLookInput(isController);
        ControllerPlayerMovement.ensureCorrectInput(this.minecraft.f_91074_);
        if (isController) {
            this.handleKeybinds();
            this.preventFlyDrifting();
        }
    }

    protected void handleKeybinds() {
        if (this.minecraft.f_91080_ != null) {
            return;
        }
        if (ControlifyBindings.PAUSE.on(this.controller).justPressed()) {
            this.minecraft.m_91358_(false);
        }
        if (this.minecraft.f_91074_ != null) {
            Inventory inventory = this.minecraft.f_91074_.m_150109_();
            if (this.hotbarNextRepeatHelper.shouldAction(ControlifyBindings.NEXT_SLOT.on(this.controller))) {
                this.hotbarNextRepeatHelper.onNavigate();
                this.minecraft.f_91074_.m_150109_().m_35988_(-1.0);
            }
            if (this.hotbarPrevRepeatHelper.shouldAction(ControlifyBindings.PREV_SLOT.on(this.controller))) {
                this.hotbarPrevRepeatHelper.onNavigate();
                this.minecraft.f_91074_.m_150109_().m_35988_(1.0);
            }
            if (!this.minecraft.f_91074_.m_5833_()) {
                if (ControlifyBindings.DROP_STACK.on(this.controller).justPressed()) {
                    if (this.minecraft.f_91074_.m_108700_(true)) {
                        this.minecraft.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                } else {
                    if (ControlifyBindings.DROP_INGAME.on(this.controller).justPressed()) {
                        this.dropRepeating = true;
                    } else if (ControlifyBindings.DROP_INGAME.on(this.controller).justReleased()) {
                        this.dropRepeating = false;
                    }
                    if (this.dropRepeating && this.dropRepeatHelper.shouldAction(ControlifyBindings.DROP_INGAME.on(this.controller)) && this.minecraft.f_91074_.m_108700_(false)) {
                        this.dropRepeatHelper.onNavigate();
                        this.minecraft.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                    }
                }
                if (ControlifyBindings.SWAP_HANDS.on(this.controller).justPressed()) {
                    this.minecraft.f_91074_.f_108617_.m_104955_((Packet)new ServerboundPlayerActionPacket(ServerboundPlayerActionPacket.Action.SWAP_ITEM_WITH_OFFHAND, BlockPos.f_121853_, Direction.DOWN));
                }
            }
            if (ControlifyBindings.INVENTORY.on(this.controller).justPressed()) {
                if (this.minecraft.f_91072_.m_105292_()) {
                    this.minecraft.f_91074_.m_108628_();
                } else {
                    this.minecraft.m_91301_().m_120564_();
                    this.minecraft.m_91152_((Screen)new InventoryScreen((Player)this.minecraft.f_91074_));
                }
            }
            if (ControlifyBindings.CHANGE_PERSPECTIVE.on(this.controller).justPressed()) {
                CameraType cameraType = this.minecraft.f_91066_.m_92176_();
                this.minecraft.f_91066_.m_92157_(this.minecraft.f_91066_.m_92176_().m_90614_());
                if (cameraType.m_90612_() != this.minecraft.f_91066_.m_92176_().m_90612_()) {
                    this.minecraft.f_91063_.m_109106_(this.minecraft.f_91066_.m_92176_().m_90612_() ? this.minecraft.m_91288_() : null);
                }
                this.minecraft.f_91060_.m_109826_();
            }
        }
        if (ControlifyBindings.TOGGLE_HUD_VISIBILITY.on(this.controller).justPressed()) {
            boolean bl = this.minecraft.f_91066_.f_92062_ = !this.minecraft.f_91066_.f_92062_;
        }
        if (ControlifyBindings.SHOW_PLAYER_LIST.on(this.controller).justPressed()) {
            boolean bl = this.shouldShowPlayerList = !this.shouldShowPlayerList;
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleOverlay();
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU_FPS.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleFpsOverlay();
        }
        if (ControlifyBindings.TOGGLE_DEBUG_MENU_CHARTS.on(this.controller).justPressed()) {
            DebugOverlayHelper.toggleChartsOverlay();
        }
        if (ControlifyBindings.DEBUG_RADIAL.on(this.controller).justPressed()) {
            this.minecraft.m_91152_((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.DEBUG_RADIAL.on(this.controller), RadialItems.createDebug(), (Component)Component.m_237119_(), null, null));
        }
        if (ControlifyBindings.TAKE_SCREENSHOT.on(this.controller).justPressed()) {
            File screenshotFile = ScreenshotAccessor.invokeGetFile(new File(this.minecraft.f_91069_, "screenshots"));
            Screenshot.m_92289_((File)this.minecraft.f_91069_, (RenderTarget)this.minecraft.m_91385_(), component -> this.minecraft.execute(() -> {
                this.minecraft.f_91065_.m_93076_().m_93785_(component);
                SteamDeckDriver.getDeck().ifPresent(deck -> deck.doSteamScreenshot(screenshotFile.getAbsoluteFile().toPath(), ""));
            }));
        }
        if (ControlifyBindings.PICK_BLOCK.on(this.controller).justPressed()) {
            ((PickBlockAccessor)this.minecraft).controlify$pickBlock();
        }
        if (ControlifyBindings.PICK_BLOCK_NBT.on(this.controller).justPressed()) {
            ((PickBlockAccessor)this.minecraft).controlify$pickBlockWithNbt();
        }
        if (ControlifyBindings.RADIAL_MENU.on(this.controller).justPressed()) {
            this.minecraft.m_91152_((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.RADIAL_MENU.on(this.controller), RadialItems.createBindings(this.controller), (Component)Component.m_237115_((String)"controlify.radial_menu.configure_hint"), null, null));
        }
        if (ControlifyBindings.GAME_MODE_SWITCHER.on(this.controller).justPressed()) {
            this.minecraft.m_91152_((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.GAME_MODE_SWITCHER.on(this.controller), RadialItems.createGameModes(), (Component)Component.m_237119_(), null, null));
        }
        if (ControlifyBindings.HOTBAR_SLOT_SELECT.on(this.controller).justPressed()) {
            this.minecraft.m_91152_((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.HOTBAR_SLOT_SELECT.on(this.controller), RadialItems.createHotbarItemSelect(), (Component)Component.m_237119_(), null, null));
        }
        if (this.minecraft.f_91072_.m_105290_()) {
            if (ControlifyBindings.HOTBAR_LOAD_RADIAL.on(this.controller).justPressed()) {
                this.minecraft.m_91152_((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.HOTBAR_LOAD_RADIAL.on(this.controller), RadialItems.createHotbarLoad(), (Component)Component.m_237115_((String)"controlify.radial.hotbar_load_hint"), null, null));
            }
            if (ControlifyBindings.HOTBAR_SAVE_RADIAL.on(this.controller).justPressed()) {
                this.minecraft.m_91152_((Screen)new RadialMenuScreen(this.controller, ControlifyBindings.HOTBAR_SAVE_RADIAL.on(this.controller), RadialItems.createHotbarSave(), (Component)Component.m_237115_((String)"controlify.radial.hotbar_save_hint"), null, null));
            }
        }
    }

    protected void handlePlayerLookInput(boolean isController) {
        LocalPlayer player = this.minecraft.f_91074_;
        if (!isController || !this.canProcessLookInput()) {
            this.lookInputX = 0.0;
            this.lookInputY = 0.0;
            return;
        }
        boolean aiming = this.isAiming((Player)player);
        Vector2d lookImpulse = new Vector2d();
        this.controller.gyro().ifPresent(gyro -> this.handleGyroLook((GyroComponent)gyro, lookImpulse, aiming));
        if (this.controller.gyro().map(gyro -> ((GyroComponent.Config)gyro.confObj()).lookSensitivity > 0.0f && ((GyroComponent.Config)gyro.confObj()).flickStick).orElse(false).booleanValue()) {
            this.handleFlickStick(player);
        } else {
            this.controller.input().ifPresent(input -> this.handleRegularLook((InputComponent)input, lookImpulse, aiming, player));
        }
        LookInputModifier modifier = new LookInputModifier(new Vector2f((float)lookImpulse.x, (float)lookImpulse.y), this.controller);
        ControlifyEvents.LOOK_INPUT_MODIFIER.invoke(modifier);
        lookImpulse.set((Vector2fc)modifier.lookInput());
        this.lookInputX = lookImpulse.x;
        this.lookInputY = lookImpulse.y;
        this.wasAiming = aiming;
    }

    protected void handleRegularLook(InputComponent input, Vector2d impulse, boolean aiming, LocalPlayer player) {
        InputComponent.Config config = (InputComponent.Config)input.confObj();
        Vector2d regularImpulse = new Vector2d((double)(ControlifyBindings.LOOK_RIGHT.on(this.controller).analogueNow() - ControlifyBindings.LOOK_LEFT.on(this.controller).analogueNow()), (double)(ControlifyBindings.LOOK_DOWN.on(this.controller).analogueNow() - ControlifyBindings.LOOK_UP.on(this.controller).analogueNow()));
        if (config.vLookInvert) {
            regularImpulse.y *= -1.0;
        }
        if (!config.isLCE) {
            ControllerUtils.applyEasingToLength(regularImpulse, d -> d * Math.abs(d));
        } else {
            regularImpulse.x *= Math.abs(regularImpulse.x);
            regularImpulse.y *= Math.abs(regularImpulse.y);
        }
        if (config.reduceAimingSensitivity && player.m_6117_()) {
            float f;
            if (config.isLCE) {
                switch (player.m_21211_().m_41780_()) {
                    case BOW: 
                    case CROSSBOW: 
                    case SPEAR: 
                    case SPYGLASS: {
                        f = 0.15f;
                        break;
                    }
                    default: {
                        f = 1.0f;
                        break;
                    }
                }
            } else {
                switch (player.m_21211_().m_41780_()) {
                    case BOW: 
                    case CROSSBOW: 
                    case SPEAR: {
                        f = 0.6f;
                        break;
                    }
                    case SPYGLASS: {
                        f = 0.2f;
                        break;
                    }
                    default: {
                        f = 1.0f;
                    }
                }
            }
            float aimMultiplier = f;
            regularImpulse.mul((double)aimMultiplier);
        }
        regularImpulse.x *= (double)(config.hLookSensitivity * 10.0f);
        regularImpulse.y *= (double)(config.vLookSensitivity * 10.0f);
        impulse.add((Vector2dc)regularImpulse);
    }

    protected void handleGyroLook(GyroComponent gyro, Vector2d impulse, boolean aiming) {
        GyroComponent.Config config = (GyroComponent.Config)gyro.confObj();
        InputBinding gyroButton = ControlifyBindings.GYRO_BUTTON.on(this.controller);
        if (config.requiresButton.equals((Object)GyroButtonMode.ON) && !gyroButton.digitalNow() && !aiming) {
            this.gyroInput.set(0.0f);
        } else if (config.requiresButton.equals((Object)GyroButtonMode.INVERT) && gyroButton.digitalNow() && !aiming) {
            this.gyroInput.set(0.0f);
        } else if (config.requiresButton.equals((Object)GyroButtonMode.TOGGLE) && !this.gyroToggledOn && !aiming) {
            this.gyroInput.set(0.0f);
        } else if (config.relativeGyroMode) {
            this.gyroInput.add(new GyroState(gyro.getState()).mul(0.1f));
        } else {
            this.gyroInput.set(gyro.getState());
        }
        if (config.requiresButton.equals((Object)GyroButtonMode.TOGGLE) && gyroButton.justPressed()) {
            this.gyroToggledOn = !this.gyroToggledOn;
        }
        GyroState thisInput = new GyroState(this.gyroInput).mul(57.295776f).div(20.0f).mul(config.lookSensitivity);
        impulse.y = impulse.y + (double)(-thisInput.pitch() * (float)(config.invertY ? -1 : 1));
        double d = impulse.x;
        impulse.x = d + (double)((switch (config.yawMode) {
            default -> throw new IncompatibleClassChangeError();
            case GyroYawMode.YAW -> -thisInput.yaw();
            case GyroYawMode.ROLL -> -thisInput.roll();
            case GyroYawMode.BOTH -> -thisInput.yaw() - thisInput.roll();
        }) * (float)(config.invertX ? -1 : 1));
    }

    protected void handleFlickStick(LocalPlayer player) {
        float y = ControlifyBindings.LOOK_DOWN.on(this.controller).analogueNow() - ControlifyBindings.LOOK_UP.on(this.controller).analogueNow();
        float x = ControlifyBindings.LOOK_RIGHT.on(this.controller).analogueNow() - ControlifyBindings.LOOK_LEFT.on(this.controller).analogueNow();
        float flickAngle = Mth.m_14177_((float)((float)Mth.m_14136_((double)y, (double)x) * 57.295776f + 90.0f));
        if (!(ControlifyBindings.LOOK_DOWN.on(this.controller).justPressed() || ControlifyBindings.LOOK_UP.on(this.controller).justPressed() || ControlifyBindings.LOOK_LEFT.on(this.controller).justPressed() || ControlifyBindings.LOOK_RIGHT.on(this.controller).justPressed())) {
            return;
        }
        if (this.flickAnimation != null && this.flickAnimation.isPlaying()) {
            this.flickAnimation.skipToEnd();
        }
        this.flickAnimation = Animation.of(8).easing(EasingFunction.EASE_OUT_EXPO).deltaConsumerD(angle -> player.m_19884_(angle.doubleValue(), 0.0), 0.0, (double)flickAngle / 0.15).play();
    }

    public void processPlayerLook(float deltaTime) {
        if (this.minecraft.f_91074_ != null) {
            double velX = this.lookInputX / 0.15 * (double)deltaTime;
            double velY = this.lookInputY / 0.15 * (double)deltaTime;
            this.minecraft.f_91074_.m_19884_(velX, velY);
            this.minecraft.m_91301_().m_120565_(velX, velY);
        }
    }

    public boolean shouldShowPlayerList() {
        return this.shouldShowPlayerList;
    }

    public void preventFlyDrifting() {
        if (!this.controller.genericConfig().config().disableFlyDrifting || !ServerPolicies.DISABLE_FLY_DRIFTING.get()) {
            return;
        }
        LocalPlayer player = this.minecraft.f_91074_;
        if (player != null && player.m_150110_().f_35935_ && !player.m_20096_()) {
            Vec3 motion = player.m_20184_();
            double x = motion.f_82479_;
            double y = motion.f_82480_;
            double z = motion.f_82481_;
            boolean jumping = player.f_108618_.f_108572_;
            boolean shiftKeyDown = player.f_108618_.f_108573_;
            if (!jumping) {
                y = Math.min(y, 0.0);
            }
            if (!shiftKeyDown) {
                y = Math.max(y, 0.0);
            }
            Vec2 moveVec = InGameInputHandler.getMoveVec(player.f_108618_);
            if (moveVec.f_82470_ == 0.0f && moveVec.f_82471_ == 0.0f) {
                x = 0.0;
                z = 0.0;
            }
            player.m_20334_(x, y, z);
        }
    }

    private boolean isAiming(Player player) {
        boolean bl;
        block4: {
            block3: {
                if (!player.m_6117_()) break block3;
                switch (player.m_21211_().m_41780_()) {
                    case BOW: 
                    case CROSSBOW: 
                    case SPEAR: 
                    case SPYGLASS: {
                        break;
                    }
                    default: {
                        break block3;
                    }
                }
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    private boolean canProcessLookInput() {
        boolean mouseNotGrabbed = !this.minecraft.f_91067_.m_91600_() && !this.controlify.config().globalSettings().outOfFocusInput;
        boolean outOfFocus = !this.minecraft.m_91302_() && !this.controlify.config().globalSettings().outOfFocusInput;
        boolean screenVisible = this.minecraft.f_91080_ != null;
        boolean playerExists = this.minecraft.f_91074_ != null;
        return !mouseNotGrabbed && !outOfFocus && !screenVisible && playerExists;
    }

    public static Vec2 getMoveVec(Input input) {
        return new Vec2(input.f_108566_, input.f_108567_);
    }
}

