/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.platform.client.neoforge;

import dev.isxander.controlify.platform.client.CreativeTabHelper;
import dev.isxander.controlify.platform.client.PlatformClientUtilImpl;
import dev.isxander.controlify.platform.client.events.DisconnectedEvent;
import dev.isxander.controlify.platform.client.events.LifecycleEvent;
import dev.isxander.controlify.platform.client.events.ScreenRenderEvent;
import dev.isxander.controlify.platform.client.events.TickEvent;
import dev.isxander.controlify.platform.client.neoforge.NeoforgeCreativeTabHelper;
import dev.isxander.controlify.platform.client.resource.ControlifyReloadListener;
import dev.isxander.controlify.platform.client.util.RenderLayer;
import dev.isxander.controlify.platform.neoforge.VanillaKeyMappingHolder;
import dev.isxander.controlify.platform.network.ControlifyPacketCodec;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModInfo;
import org.jetbrains.annotations.Nullable;

public class NeoforgePlatformClientImpl
implements PlatformClientUtilImpl {
    @Nullable
    private Collection<KeyMapping> moddedKeyMappings;

    @Override
    public void registerClientTickStarted(TickEvent event) {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase != TickEvent.Phase.START) {
                return;
            }
            event.onTick(Minecraft.m_91087_());
        });
    }

    @Override
    public void registerClientTickEnded(TickEvent event) {
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.phase != TickEvent.Phase.END) {
                return;
            }
            event.onTick(Minecraft.m_91087_());
        });
    }

    @Override
    public void registerClientStopping(LifecycleEvent event) {
        MinecraftForge.EVENT_BUS.addListener(e -> event.onLifecycle(Minecraft.m_91087_()));
    }

    @Override
    public void registerClientDisconnected(DisconnectedEvent event) {
        MinecraftForge.EVENT_BUS.addListener(e -> event.onDisconnected(Minecraft.m_91087_()));
    }

    @Override
    public void registerAssetReloadListener(ControlifyReloadListener reloadListener) {
        this.getModEventBus().addListener(e -> e.registerReloadListener((PreparableReloadListener)reloadListener));
    }

    @Override
    public void registerBuiltinResourcePack(ResourceLocation id, Component displayName) {
        ResourceLocation packLocation = id.m_246208_("resourcepacks/");
        this.getModEventBus().addListener(e -> {
            IModInfo modInfo = ((ModContainer)ModList.get().getModContainerById(packLocation.m_135827_()).orElseThrow()).getModInfo();
            Path resourcePath = modInfo.getOwningFile().getFile().findResource(new String[]{packLocation.m_135815_()});
        });
    }

    @Override
    public void addHudLayer(ResourceLocation id, RenderLayer renderLayer) {
        this.getModEventBus().addListener(event -> event.registerAboveAll(id.m_135815_(), (IGuiOverlay)renderLayer));
    }

    @Override
    public void registerPostScreenRender(ScreenRenderEvent event) {
        MinecraftForge.EVENT_BUS.addListener(e -> event.onRender(e.getScreen(), e.getGuiGraphics(), e.getMouseX(), e.getMouseY(), e.getPartialTick()));
    }

    @Override
    public Collection<KeyMapping> getModdedKeyMappings() {
        if (this.moddedKeyMappings == null) {
            this.moddedKeyMappings = this.calculateModdedKeyMappings();
        }
        return this.moddedKeyMappings;
    }

    private Collection<KeyMapping> calculateModdedKeyMappings() {
        Options options = Minecraft.m_91087_().f_91066_;
        KeyMapping[] vanillaAndModded = options.f_92059_;
        List<KeyMapping> vanillaOnly = Arrays.asList(((VanillaKeyMappingHolder)options).controlify$getVanillaKeys());
        return Arrays.stream(vanillaAndModded).filter(key -> !vanillaOnly.contains(key)).toList();
    }

    @Override
    public <I, O> void setupClientsideHandshake(ResourceLocation handshakeId, ControlifyPacketCodec<I> clientBoundCodec, ControlifyPacketCodec<O> serverBoundCodec, Function<I, O> handshakeHandler) {
    }

    @Override
    public CreativeTabHelper createCreativeTabHelper(CreativeModeInventoryScreen creativeScreen) {
        return new NeoforgeCreativeTabHelper(creativeScreen);
    }

    private IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }
}

