/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.rumble;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import dev.isxander.controlify.utils.CUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public record RumbleSource(ResourceLocation id) {
    public static final Codec<RumbleSource> CODEC = ResourceLocation.f_135803_.xmap(RumbleSource::get, RumbleSource::id);
    private static final Map<ResourceLocation, RumbleSource> SOURCES = new Object2ObjectLinkedOpenHashMap();
    public static final RumbleSource MASTER = RumbleSource.register("master");
    public static final RumbleSource PLAYER = RumbleSource.register("player");
    public static final RumbleSource WORLD = RumbleSource.register("world");
    public static final RumbleSource INTERACTION = RumbleSource.register("interaction");
    public static final RumbleSource GUI = RumbleSource.register("gui");

    public static RumbleSource get(ResourceLocation id) {
        RumbleSource source = SOURCES.get(id);
        if (source == null) {
            CUtil.LOGGER.warn("Unknown rumble source: {}. Using master.", id);
            return MASTER;
        }
        return source;
    }

    public static Collection<RumbleSource> values() {
        return SOURCES.values();
    }

    public static JsonObject getDefaultJson() {
        JsonObject object = new JsonObject();
        for (RumbleSource source : SOURCES.values()) {
            object.addProperty(source.id().toString(), (Number)Float.valueOf(1.0f));
        }
        return object;
    }

    public static Map<ResourceLocation, Float> getDefaultMap() {
        HashMap<ResourceLocation, Float> map = new HashMap<ResourceLocation, Float>();
        for (RumbleSource source : SOURCES.values()) {
            map.put(source.id(), Float.valueOf(1.0f));
        }
        return map;
    }

    public static RumbleSource register(ResourceLocation id) {
        RumbleSource source = new RumbleSource(id);
        SOURCES.put(id, source);
        return source;
    }

    public static RumbleSource register(String identifier, String path) {
        return RumbleSource.register(CUtil.rl(identifier, path));
    }

    private static RumbleSource register(String path) {
        return RumbleSource.register("controlify", path);
    }
}

