/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.compat.vanilla;

import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenProcessor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractSliderButton;

public class SliderComponentProcessor
implements ComponentProcessor {
    private final Supplier<Boolean> canChangeValueGetter;
    private final Consumer<Boolean> canChangeValueSetter;
    private final AbstractSliderButton component;
    private static final int SLIDER_CHANGE_DELAY = 1;
    private int lastSliderChange = 1;

    public SliderComponentProcessor(AbstractSliderButton component, Supplier<Boolean> canChangeValueGetter, Consumer<Boolean> canChangeValueSetter) {
        this.component = component;
        this.canChangeValueGetter = canChangeValueGetter;
        this.canChangeValueSetter = canChangeValueSetter;
    }

    @Override
    public boolean overrideControllerNavigation(ScreenProcessor<?> screen, ControllerEntity controller) {
        boolean canSliderChange;
        if (!this.canChangeValueGetter.get().booleanValue()) {
            return false;
        }
        boolean bl = canSliderChange = ++this.lastSliderChange > 1;
        if (ControlifyBindings.GUI_NAVI_RIGHT.on(controller).digitalNow()) {
            if (canSliderChange) {
                this.component.m_7933_(262, 0, 0);
                this.lastSliderChange = 0;
            }
            return true;
        }
        if (ControlifyBindings.GUI_NAVI_LEFT.on(controller).digitalNow()) {
            if (canSliderChange) {
                this.component.m_7933_(263, 0, 0);
                this.lastSliderChange = 0;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
        if (!this.canChangeValueGetter.get().booleanValue()) {
            return false;
        }
        if (ControlifyBindings.GUI_BACK.on(controller).justPressed()) {
            this.canChangeValueSetter.accept(false);
            return true;
        }
        return false;
    }

    @Override
    public void onFocusGained(ScreenProcessor<?> screen, ControllerEntity controller) {
        this.canChangeValueSetter.accept(false);
    }
}

