/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.animation.impl;

import dev.isxander.controlify.utils.animation.api.Animatable;
import dev.isxander.controlify.utils.animation.api.AnimationSequence;
import dev.isxander.controlify.utils.animation.impl.Animator;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang3.Validate;

public class AnimationSequenceImpl
implements AnimationSequence {
    private final Queue<Animatable> queue = new ArrayDeque<Animatable>();
    private Animatable current = null;
    private boolean started;
    private boolean done;

    @Override
    public AnimationSequence push(Animatable ... animatables) {
        Validate.isTrue((!this.isDone() ? 1 : 0) != 0, (String)"Cannot add to sequence that has already completed.", (Object[])new Object[0]);
        for (Animatable animatable : animatables) {
            Validate.isTrue((!animatable.hasStarted() ? 1 : 0) != 0, (String)"Cannot add an animation that has already started!", (Object[])new Object[0]);
        }
        this.queue.addAll(List.of(animatables));
        return this;
    }

    @Override
    public void tick(float tickDelta) {
        if (this.current == null) {
            this.current = this.queue.poll();
            if (this.current != null) {
                this.current.play();
                this.started = true;
            } else {
                this.done = true;
            }
        } else {
            this.current.tick(tickDelta);
            if (this.current.isDone()) {
                this.current = null;
            }
        }
    }

    @Override
    public boolean hasStarted() {
        return this.started;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isPlaying() {
        return this.started && !this.done;
    }

    @Override
    public AnimationSequence play() {
        Animator.INSTANCE.add(this);
        return this;
    }

    @Override
    public void skipToEnd() {
        while (this.current != null) {
            this.current.skipToEnd();
            this.current = this.queue.poll();
        }
        this.done = true;
    }

    @Override
    public void abort() {
        while (this.current != null) {
            this.current.abort();
            this.current = this.queue.poll();
        }
        this.done = true;
    }

    @Override
    public AnimationSequence copy() {
        Validate.isTrue((!this.started ? 1 : 0) != 0, (String)"Cannot copy an animation sequence that has already started.", (Object[])new Object[0]);
        AnimationSequence sequence = AnimationSequence.of();
        this.queue.forEach(animation -> sequence.push(animation.copy()));
        return sequence;
    }
}

