/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.utils.log;

import dev.isxander.controlify.utils.log.ControlifyLogger;
import dev.isxander.controlify.utils.log.LogLevel;
import dev.isxander.controlify.utils.log.LogMessage;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.CrashReport;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractControlifyLogger
implements ControlifyLogger {
    private final Queue<LogMessage> logMessages = new ConcurrentLinkedQueue<LogMessage>();

    @Override
    public void log(String message) {
        this.log0(message, new Object[0], null, false, LogLevel.INFO);
    }

    @Override
    public void log(String message, Object ... args) {
        this.log0(message, args, null, false, LogLevel.INFO);
    }

    @Override
    public void log(String message, Throwable throwable, Object ... args) {
        this.log0(message, args, throwable, false, LogLevel.INFO);
    }

    @Override
    public void log(String message, Throwable throwable) {
        this.log0(message, new Object[0], throwable, false, LogLevel.INFO);
    }

    @Override
    public void warn(String message) {
        this.log0(message, new Object[0], null, false, LogLevel.WARN);
    }

    @Override
    public void warn(String message, Object ... args) {
        this.log0(message, args, null, false, LogLevel.WARN);
    }

    @Override
    public void warn(String message, Throwable throwable) {
        this.log0(message, new Object[0], throwable, false, LogLevel.WARN);
    }

    @Override
    public void warn(String message, Throwable throwable, Object ... args) {
        this.log0(message, args, throwable, false, LogLevel.WARN);
    }

    @Override
    public void error(String message) {
        this.log0(message, new Object[0], null, false, LogLevel.ERROR);
    }

    @Override
    public void error(String message, Object ... args) {
        this.log0(message, args, null, false, LogLevel.ERROR);
    }

    @Override
    public void error(String message, Throwable throwable) {
        this.log0(message, new Object[0], throwable, false, LogLevel.ERROR);
    }

    @Override
    public void error(String message, Throwable throwable, Object ... args) {
        this.log0(message, args, throwable, false, LogLevel.ERROR);
    }

    @Override
    public void debugLog(String message) {
        this.log0(message, new Object[0], null, true, LogLevel.INFO);
    }

    @Override
    public void debugLog(String message, Object ... args) {
        this.log0(message, args, null, true, LogLevel.INFO);
    }

    @Override
    public void debugLog(String message, Throwable throwable) {
        this.log0(message, new Object[0], throwable, true, LogLevel.INFO);
    }

    @Override
    public void debugLog(String message, Throwable throwable, Object ... args) {
        this.log0(message, args, throwable, true, LogLevel.INFO);
    }

    @Override
    public void debugWarn(String message) {
        this.log0(message, new Object[0], null, true, LogLevel.WARN);
    }

    @Override
    public void debugWarn(String message, Object ... args) {
        this.log0(message, args, null, true, LogLevel.WARN);
    }

    @Override
    public void debugWarn(String message, Throwable throwable) {
        this.log0(message, new Object[0], throwable, true, LogLevel.WARN);
    }

    @Override
    public void debugWarn(String message, Throwable throwable, Object ... args) {
        this.log0(message, args, throwable, true, LogLevel.WARN);
    }

    @Override
    public void debugError(String message) {
        this.log0(message, new Object[0], null, true, LogLevel.ERROR);
    }

    @Override
    public void debugError(String message, Object ... args) {
        this.log0(message, args, null, true, LogLevel.ERROR);
    }

    @Override
    public void debugError(String message, Throwable throwable) {
        this.log0(message, new Object[0], throwable, true, LogLevel.ERROR);
    }

    @Override
    public void debugError(String message, Throwable throwable, Object ... args) {
        this.log0(message, args, throwable, true, LogLevel.ERROR);
    }

    @Override
    public void crashReport(CrashReport report) {
        this.debugError(report.m_127526_());
    }

    @Override
    public void validateIsTrue(boolean condition, String message) {
        if (!condition) {
            this.debugError("Validation failed: " + message);
            throw new AssertionError((Object)("Validation failed: " + message));
        }
    }

    protected void log0(String message, Object[] args, @Nullable Throwable throwable, boolean debug, LogLevel level) {
        this.logMessages.add(new LogMessage(message, args, throwable, debug, level));
    }

    @Override
    public String export() {
        return this.logMessages.stream().reduce(new StringBuilder(), (b, m) -> m.append((StringBuilder)b), StringBuilder::append).toString();
    }
}

