/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SculkSensorBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.ItemSignalParticleOption;
import sculktransporting.misc.OneReceiverVibrationListener;
import sculktransporting.registration.STGameEvents;

public abstract class BaseSculkItemTransporterBlockEntity
extends SculkSensorBlockEntity {
    protected ItemStack storedItemSignal = ItemStack.EMPTY;
    protected BlockPos signalOrigin;
    protected ItemEntity cachedItemEntity;
    protected long placedDownTick = 0L;
    protected long lastHandledSignalTick = 0L;

    protected BaseSculkItemTransporterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
        this.vibrationListener = new OneReceiverVibrationListener((VibrationSystem)this);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BaseSculkItemTransporterBlockEntity be) {
        be.setPlacedDown(level.getGameTime());
        VibrationSystem.Ticker.tick((Level)level, (VibrationSystem.Data)be.getVibrationData(), (VibrationSystem.User)be.getVibrationUser());
        if (!be.storedItemSignal.isEmpty()) {
            if (be.cachedItemEntity == null) {
                be.level.updateNeighborsAt(pos, state.getBlock());
                be.cachedItemEntity = new ItemEntity(level, (double)be.signalOrigin.getX(), (double)be.signalOrigin.getY(), (double)be.signalOrigin.getZ(), be.storedItemSignal);
            }
            if (be.shouldPerformAction(level) && be.cachedItemEntity.isAlive()) {
                level.gameEvent((Entity)be.cachedItemEntity, STGameEvents.ITEM_TRANSMITTABLE, pos);
            }
        }
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Entity entity;
        if (this.hasStoredItemSignal()) {
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)this.getStoredItemSignal());
        } else if (this.getVibrationData().getCurrentVibration() != null && (entity = this.getVibrationData().getCurrentVibration().entity()) instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            Containers.dropItemStack((Level)this.level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)item.getItem());
        }
        super.preRemoveSideEffects(pos, state);
    }

    public VibrationSystem.User createVibrationUser() {
        return new BaseVibrationUser(this.getBlockPos());
    }

    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.storedItemSignal = tag.read("StoredItemSignal", ItemStack.CODEC).orElse(ItemStack.EMPTY);
        this.signalOrigin = tag.read("signal_origin", BlockPos.CODEC).orElse(null);
        this.placedDownTick = tag.getLongOr("placedDownTick", 0L);
        this.lastHandledSignalTick = tag.getLongOr("lastHandledSignalTick", 0L);
    }

    protected void saveAdditional(ValueOutput tag) {
        Entity entity;
        super.saveAdditional(tag);
        if (!this.storedItemSignal.isEmpty()) {
            tag.store("StoredItemSignal", ItemStack.CODEC, (Object)this.storedItemSignal);
            tag.store("signal_origin", BlockPos.CODEC, (Object)this.signalOrigin);
        } else if (this.getVibrationData().getCurrentVibration() != null && (entity = this.getVibrationData().getCurrentVibration().entity()) instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            tag.store("StoredItemSignal", ItemStack.CODEC, (Object)item.getItem());
            tag.store("signal_origin", BlockPos.CODEC, (Object)item.blockPosition());
        }
        tag.putLong("placedDownTick", this.placedDownTick);
        tag.putLong("lastHandledSignalTick", this.lastHandledSignalTick);
    }

    public abstract boolean shouldPerformAction(Level var1);

    public boolean hasStoredItemSignal() {
        return !this.storedItemSignal.isEmpty();
    }

    public ItemStack getStoredItemSignal() {
        return this.storedItemSignal;
    }

    public void setItemSignal(ItemEntity itemSignal, int power) {
        if (itemSignal == null) {
            this.storedItemSignal = ItemStack.EMPTY;
            this.signalOrigin = null;
            this.level.updateNeighborsAt(this.worldPosition, this.getBlockState().getBlock());
        } else {
            Block block;
            boolean shouldActivate = this.storedItemSignal.isEmpty();
            this.storedItemSignal = itemSignal.getItem().copy();
            this.signalOrigin = itemSignal.blockPosition();
            if (shouldActivate && (block = this.getBlockState().getBlock()) instanceof BaseSculkItemTransporterBlock) {
                BaseSculkItemTransporterBlock sculkItemTransporterBlock = (BaseSculkItemTransporterBlock)block;
                sculkItemTransporterBlock.activate((Entity)itemSignal, this.level, this.worldPosition, this.getBlockState(), power, 0);
            }
        }
        this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 0);
        this.lastHandledSignalTick = this.level.getGameTime();
        this.cachedItemEntity = null;
    }

    public long getPlacedDownTick() {
        return this.placedDownTick;
    }

    public void setPlacedDown(long gameTime) {
        if (this.placedDownTick <= 0L) {
            this.placedDownTick = gameTime;
        }
    }

    public boolean isValidBlockState(BlockState state) {
        return this.getType().isValid(state);
    }

    public abstract BlockEntityType<?> getType();

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveCustomOnly(lookupProvider);
    }

    public class BaseVibrationUser
    extends SculkSensorBlockEntity.VibrationUser {
        public BaseVibrationUser(BlockPos pos) {
            super((SculkSensorBlockEntity)BaseSculkItemTransporterBlockEntity.this, pos);
        }

        public boolean isValidVibration(Holder<GameEvent> gameEvent, GameEvent.Context ctx) {
            ItemEntity item;
            Entity entity;
            return gameEvent.is(STGameEvents.ITEM_TRANSMITTABLE) && (entity = ctx.sourceEntity()) instanceof ItemEntity && (item = (ItemEntity)entity).isAlive();
        }

        public boolean canReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> event, GameEvent.Context ctx) {
            ItemEntity item;
            Entity entity;
            return BaseSculkItemTransporterBlockEntity.this.storedItemSignal.isEmpty() && (entity = ctx.sourceEntity()) instanceof ItemEntity && !(item = (ItemEntity)entity).blockPosition().equals((Object)BaseSculkItemTransporterBlockEntity.this.worldPosition) && BaseSculkItemTransporterBlockEntity.this.lastHandledSignalTick < level.getGameTime() && SculkSensorBlock.canActivate((BlockState)BaseSculkItemTransporterBlockEntity.this.getBlockState());
        }

        public void onDataChanged() {
            Entity entity;
            super.onDataChanged();
            if (BaseSculkItemTransporterBlockEntity.this.getVibrationData().getCurrentVibration() != null && (entity = BaseSculkItemTransporterBlockEntity.this.getVibrationData().getCurrentVibration().entity()) instanceof ItemEntity) {
                BaseSculkItemTransporterBlockEntity be;
                ItemEntity item = (ItemEntity)entity;
                Vec3 originVec = BaseSculkItemTransporterBlockEntity.this.getVibrationData().getCurrentVibration().pos();
                BlockPos originPos = BlockPos.containing((Position)originVec);
                BlockEntity blockEntity = BaseSculkItemTransporterBlockEntity.this.level.getBlockEntity(originPos);
                if (blockEntity instanceof BaseSculkItemTransporterBlockEntity && (be = (BaseSculkItemTransporterBlockEntity)blockEntity).hasStoredItemSignal() && be.getStoredItemSignal() == item.getItem()) {
                    be.setItemSignal(null, 0);
                    BaseSculkItemTransporterBlockEntity.this.level.scheduleTick(originPos, be.getBlockState().getBlock(), 0);
                    item.setPos(originVec);
                    ((ServerLevel)BaseSculkItemTransporterBlockEntity.this.level).sendParticles((ParticleOptions)new ItemSignalParticleOption(BaseSculkItemTransporterBlockEntity.this.getListener().getListenerSource(), BaseSculkItemTransporterBlockEntity.this.getVibrationData().getTravelTimeInTicks(), item.getItem().copy()), originVec.x, originVec.y, originVec.z, (item.getItem().getCount() + 15) / 16 * 5, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }

        public void onReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> event, Entity entity, Entity projectileOwner, float distance) {
            super.onReceiveVibration(level, pos, event, entity, projectileOwner, distance);
            if (event.is(STGameEvents.ITEM_TRANSMITTABLE) && entity instanceof ItemEntity) {
                ItemEntity item = (ItemEntity)entity;
                BaseSculkItemTransporterBlockEntity.this.setItemSignal(item, VibrationSystem.getRedstoneStrengthForDistance((float)distance, (int)this.getListenerRadius()));
            }
        }
    }
}

