/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.ResourceHandlerUtil;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.ResourceStack;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import sculktransporting.STTags;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkEmitterBlockEntity
extends BaseSculkItemTransporterBlockEntity {
    private BlockState lastKnownStateBelow;
    private BlockCapabilityCache<ResourceHandler<ItemResource>, Direction> inventoryBelow;
    private QuantityModifierItem.QuantityTier quantityTier = QuantityModifierItem.QuantityTier.ZERO;
    private SpeedModifierItem.SpeedTier speedTier = SpeedModifierItem.SpeedTier.ZERO;

    public SculkEmitterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SculkEmitterBlockEntity be) {
        ResourceHandler itemHandler;
        if (!be.hasStoredItemSignal() && be.inventoryBelow != null && be.canExtractFromBelow() && (itemHandler = (ResourceHandler)be.inventoryBelow.getCapability()) != null) {
            try (Transaction transaction = Transaction.openRoot();){
                ResourceStack extracted = ResourceHandlerUtil.extractFirst((ResourceHandler)itemHandler, (Predicate)Predicates.alwaysTrue(), (int)be.getAmountToExtract(), (TransactionContext)transaction);
                if (extracted != null && !extracted.isEmpty()) {
                    be.setItemSignal(new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), ((ItemResource)extracted.resource()).toStack(extracted.amount())), 15);
                }
                transaction.commit();
            }
        }
        if (be.shouldPerformAction(level)) {
            BaseSculkItemTransporterBlockEntity.serverTick(level, pos, state, be);
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getSpeedTier().getItem()));
        Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getQuantityTier().getItem()));
        super.preRemoveSideEffects(pos, state);
    }

    public int getAmountToExtract() {
        return this.quantityTier == QuantityModifierItem.QuantityTier.THREE ? 99 : (int)Math.pow(4.0, this.quantityTier.getValue());
    }

    @Override
    public VibrationSystem.User createVibrationUser() {
        return new SculkEmitterVibrationUser(this, this.getBlockPos());
    }

    @Override
    public boolean shouldPerformAction(Level level) {
        return this.speedTier == SpeedModifierItem.SpeedTier.FOUR || level.getGameTime() % (long)(20 - this.speedTier.getValue() * 5) == 0L;
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.quantityTier = QuantityModifierItem.QuantityTier.values()[tag.getIntOr("QuantityTier", 0)];
        this.speedTier = SpeedModifierItem.SpeedTier.values()[tag.getIntOr("SpeedTier", 0)];
    }

    @Override
    protected void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.putInt("QuantityTier", this.quantityTier.ordinal());
        tag.putInt("SpeedTier", this.speedTier.ordinal());
    }

    public boolean setQuantityTier(QuantityModifierItem.QuantityTier quantityTier) {
        if (this.quantityTier == quantityTier) {
            return false;
        }
        this.quantityTier = quantityTier;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        return true;
    }

    public void removeQuantityModifier() {
        if (this.quantityTier == QuantityModifierItem.QuantityTier.ZERO) {
            return;
        }
        this.setQuantityTier(QuantityModifierItem.QuantityTier.ZERO);
    }

    public QuantityModifierItem.QuantityTier getQuantityTier() {
        return this.quantityTier;
    }

    public boolean setSpeedTier(SpeedModifierItem.SpeedTier speedTier) {
        if (this.speedTier == speedTier) {
            return false;
        }
        this.speedTier = speedTier;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        return true;
    }

    public void removeSpeedModifier() {
        if (this.speedTier == SpeedModifierItem.SpeedTier.ZERO) {
            return;
        }
        this.setSpeedTier(SpeedModifierItem.SpeedTier.ZERO);
    }

    public SpeedModifierItem.SpeedTier getSpeedTier() {
        return this.speedTier;
    }

    public BlockState getLastKnownStateBelow() {
        if (this.lastKnownStateBelow == null) {
            if (this.level != null) {
                this.lastKnownStateBelow = this.level.getBlockState(this.worldPosition.relative(((Direction)this.getBlockState().getValue(BaseSculkItemTransporterBlock.FACING)).getOpposite()));
            } else {
                return Blocks.AIR.defaultBlockState();
            }
        }
        return this.lastKnownStateBelow;
    }

    public void setLastKnownStateBelow(BlockState lastKnownStateBelow) {
        this.lastKnownStateBelow = lastKnownStateBelow;
    }

    public boolean canExtractFromBelow() {
        return this.getLastKnownStateBelow().is(STTags.Blocks.SCULK_EMITTER_CAN_EXTRACT_FROM);
    }

    @Override
    public BlockEntityType<?> getType() {
        return (BlockEntityType)STBlockEntityTypes.SCULK_EMITTER_BLOCK_ENTITY.get();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ClientHandler.SPEED_TIER, (Object)this.speedTier).with(ClientHandler.QUANTITY_TIER, (Object)this.quantityTier).build();
    }

    public void onDataPacket(Connection net, ValueInput tag) {
        super.onDataPacket(net, tag);
        this.requestModelDataUpdate();
        Minecraft.getInstance().levelRenderer.setBlocksDirty(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            Direction direction = (Direction)this.getBlockState().getValue(BaseSculkItemTransporterBlock.FACING);
            this.inventoryBelow = BlockCapabilityCache.create((BlockCapability)Capabilities.Item.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(direction.getOpposite()), (Object)direction);
        }
    }

    public class SculkEmitterVibrationUser
    extends BaseSculkItemTransporterBlockEntity.BaseVibrationUser {
        public SculkEmitterVibrationUser(SculkEmitterBlockEntity this$0, BlockPos pos) {
            super(pos);
        }

        @Override
        public boolean isValidVibration(Holder<GameEvent> gameEvent, GameEvent.Context ctx) {
            return false;
        }

        @Override
        public boolean canReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> event, GameEvent.Context ctx) {
            return false;
        }

        @Override
        public void onDataChanged() {
        }

        @Override
        public void onReceiveVibration(ServerLevel level, BlockPos pos, Holder<GameEvent> event, Entity entity, Entity projectileOwner, float distance) {
        }
    }
}

