/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.model.data.ModelData;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkReceiverBlockEntity
extends BaseSculkItemTransporterBlockEntity {
    private BlockCapabilityCache<ResourceHandler<ItemResource>, Direction> inventoryBelow;
    private SpeedModifierItem.SpeedTier speedTier = SpeedModifierItem.SpeedTier.ZERO;

    public SculkReceiverBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SculkReceiverBlockEntity be) {
        ResourceHandler itemHandler;
        be.setPlacedDown(level.getGameTime());
        VibrationSystem.Ticker.tick((Level)level, (VibrationSystem.Data)be.getVibrationData(), (VibrationSystem.User)be.getVibrationUser());
        if (be.shouldPerformAction(level) && be.hasStoredItemSignal() && be.inventoryBelow != null && (itemHandler = (ResourceHandler)be.inventoryBelow.getCapability()) != null) {
            ItemStack toInsert = be.storedItemSignal;
            int amountToInsert = toInsert.getCount();
            try (Transaction transaction = Transaction.openRoot();){
                int inserted = itemHandler.insert((Resource)ItemResource.of((ItemStack)toInsert), amountToInsert, (TransactionContext)transaction);
                if (inserted == amountToInsert) {
                    be.setItemSignal(null, 0);
                    BaseSculkItemTransporterBlock.deactivate(level, be.worldPosition, be.getBlockState());
                } else {
                    ItemStack remainder = toInsert.copy();
                    remainder.shrink(inserted);
                    be.storedItemSignal = remainder;
                }
                transaction.commit();
            }
        }
    }

    @Override
    public void preRemoveSideEffects(BlockPos pos, BlockState state) {
        Block.popResource((Level)this.level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.getSpeedTier().getItem()));
        super.preRemoveSideEffects(pos, state);
    }

    @Override
    public boolean shouldPerformAction(Level level) {
        return this.speedTier == SpeedModifierItem.SpeedTier.FOUR || level.getGameTime() % (long)(20 - this.speedTier.getValue() * 5) == 0L;
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        this.speedTier = SpeedModifierItem.SpeedTier.values()[tag.getIntOr("SpeedTier", 0)];
    }

    @Override
    protected void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.putInt("SpeedTier", this.speedTier.ordinal());
    }

    public boolean setSpeedTier(SpeedModifierItem.SpeedTier speedTier) {
        if (this.speedTier == speedTier) {
            return false;
        }
        this.speedTier = speedTier;
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        return true;
    }

    public void removeSpeedModifier() {
        if (this.speedTier == SpeedModifierItem.SpeedTier.ZERO) {
            return;
        }
        this.setSpeedTier(SpeedModifierItem.SpeedTier.ZERO);
    }

    public SpeedModifierItem.SpeedTier getSpeedTier() {
        return this.speedTier;
    }

    @Override
    public BlockEntityType<?> getType() {
        return (BlockEntityType)STBlockEntityTypes.SCULK_RECEIVER_BLOCK_ENTITY.get();
    }

    public ModelData getModelData() {
        return ModelData.builder().with(ClientHandler.SPEED_TIER, (Object)this.speedTier).build();
    }

    public void onDataPacket(Connection net, ValueInput tag) {
        super.onDataPacket(net, tag);
        this.requestModelDataUpdate();
        Minecraft.getInstance().levelRenderer.setBlocksDirty(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ());
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide()) {
            Direction direction = (Direction)this.getBlockState().getValue(BaseSculkItemTransporterBlock.FACING);
            this.inventoryBelow = BlockCapabilityCache.create((BlockCapability)Capabilities.Item.BLOCK, (ServerLevel)((ServerLevel)this.level), (BlockPos)this.worldPosition.relative(direction.getOpposite()), (Object)direction);
        }
    }
}

