/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blockentities;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.blocks.SculkTransmitterBlock;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkTransmitterBlockEntity
extends BaseSculkItemTransporterBlockEntity {
    private ItemStack filteredItem = ItemStack.EMPTY;

    public SculkTransmitterBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    @Override
    public VibrationSystem.User createVibrationUser() {
        return new SculkTransmitterVibrationUser(this.getBlockPos());
    }

    @Override
    public boolean shouldPerformAction(Level level) {
        return true;
    }

    @Override
    protected void saveAdditional(ValueOutput tag) {
        super.saveAdditional(tag);
        tag.putString("FilteredItem", BuiltInRegistries.ITEM.getKey((Object)this.filteredItem.getItem()).toString());
    }

    @Override
    public void loadAdditional(ValueInput tag) {
        super.loadAdditional(tag);
        Optional item = BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getStringOr("FilteredItem", "air")));
        this.filteredItem = item.map(i -> new ItemStack((ItemLike)i.getDelegate().value())).orElse(ItemStack.EMPTY);
    }

    public void setFilteredItem(ItemStack stack) {
        if (stack.is(this.filteredItem.getItem())) {
            return;
        }
        this.filteredItem = new ItemStack((ItemLike)stack.getItem());
        this.setChanged();
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public void removeFilteredItem() {
        if (this.filteredItem.is(Items.AIR)) {
            return;
        }
        this.setFilteredItem(ItemStack.EMPTY);
    }

    public ItemStack getFilteredItem() {
        return this.filteredItem;
    }

    @Override
    public BlockEntityType<?> getType() {
        return (BlockEntityType)STBlockEntityTypes.SCULK_TRANSMITTER_BLOCK_ENTITY.get();
    }

    public class SculkTransmitterVibrationUser
    extends BaseSculkItemTransporterBlockEntity.BaseVibrationUser {
        public SculkTransmitterVibrationUser(BlockPos pos) {
            super(pos);
        }

        @Override
        public boolean isValidVibration(Holder<GameEvent> gameEvent, GameEvent.Context ctx) {
            return super.isValidVibration(gameEvent, ctx) && (SculkTransmitterBlockEntity.this.filteredItem.is(Items.AIR) || (Boolean)SculkTransmitterBlockEntity.this.getBlockState().getValue((Property)SculkTransmitterBlock.INVERTED) ^ ((ItemEntity)ctx.sourceEntity()).getItem().is(SculkTransmitterBlockEntity.this.filteredItem.getItem()));
        }
    }
}

