/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;

public abstract class BaseSculkItemTransporterBlock
extends SculkSensorBlock {
    private static final float CONVERSION_FACTOR = 0.22222222f;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;
    protected VoxelShape upShape = Block.column((double)16.0, (double)0.0, (double)8.0);
    protected VoxelShape downShape = Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected VoxelShape northShape = Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected VoxelShape eastShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected VoxelShape southShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected VoxelShape westShape = Block.box((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    protected BaseSculkItemTransporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)Direction.UP));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> this.upShape;
            case Direction.DOWN -> this.downShape;
            case Direction.NORTH -> this.northShape;
            case Direction.EAST -> this.eastShape;
            case Direction.SOUTH -> this.southShape;
            case Direction.WEST -> this.westShape;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return (BlockState)super.getStateForPlacement(ctx).setValue(FACING, (Comparable)ctx.getClickedFace());
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BaseSculkItemTransporterBlockEntity be;
        BlockEntity blockEntity;
        SculkSensorPhase phase = BaseSculkItemTransporterBlock.getPhase((BlockState)state);
        if (phase == SculkSensorPhase.COOLDOWN) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)PHASE, (Comparable)SculkSensorPhase.INACTIVE));
        } else if (phase == SculkSensorPhase.ACTIVE && (blockEntity = level.getBlockEntity(pos)) instanceof BaseSculkItemTransporterBlockEntity && !(be = (BaseSculkItemTransporterBlockEntity)blockEntity).hasStoredItemSignal()) {
            BaseSculkItemTransporterBlock.deactivate((Level)level, pos, state);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
    }

    public abstract BlockEntity newBlockEntity(BlockPos var1, BlockState var2);

    public abstract <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level var1, BlockState var2, BlockEntityType<T> var3);

    public static void deactivate(Level level, BlockPos pos, BlockState state) {
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)PHASE, (Comparable)SculkSensorPhase.INACTIVE)).setValue((Property)POWER, (Comparable)Integer.valueOf(0)));
        BaseSculkItemTransporterBlock.updateNeighbours((Level)level, (BlockPos)pos, (BlockState)state);
    }

    public void activate(Entity entity, Level level, BlockPos pos, BlockState state, int distance, int resonanceFrequency) {
        level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)PHASE, (Comparable)SculkSensorPhase.ACTIVE)).setValue((Property)POWER, (Comparable)Integer.valueOf(distance)), 3);
        level.scheduleTick(pos, state.getBlock(), 0);
        BaseSculkItemTransporterBlock.updateNeighbours((Level)level, (BlockPos)pos, (BlockState)state);
        level.gameEvent(entity, (Holder)GameEvent.SCULK_SENSOR_TENDRILS_CLICKING, pos);
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.SCULK_CLICKING, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.2f + 0.8f);
        }
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos, Direction direction) {
        BaseSculkItemTransporterBlockEntity be;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BaseSculkItemTransporterBlockEntity && (be = (BaseSculkItemTransporterBlockEntity)blockEntity).hasStoredItemSignal()) {
            return (int)(1.0 + Math.floor(0.22222222f * (float)(be.getStoredItemSignal().getCount() - 1)));
        }
        return 0;
    }

    public int getExpDrop(BlockState state, LevelAccessor level, BlockPos pos, BlockEntity be, Entity breaker, ItemStack tool) {
        return 0;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }
}

