/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import sculktransporting.STTags;
import sculktransporting.blockentities.SculkEmitterBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkEmitterBlock
extends BaseSculkItemTransporterBlock {
    public SculkEmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkEmitterBlockEntity) {
            SculkEmitterBlockEntity be = (SculkEmitterBlockEntity)blockEntity;
            boolean isQuantityModifier = heldStack.is(STTags.Items.QUANTITY_MODIFIERS);
            if (isQuantityModifier || heldStack.is(STTags.Items.SPEED_MODIFIERS)) {
                if (!level.isClientSide()) {
                    boolean modifierAdded = false;
                    if (isQuantityModifier && be.getQuantityTier() == QuantityModifierItem.QuantityTier.ZERO) {
                        modifierAdded = be.setQuantityTier(((QuantityModifierItem)heldStack.getItem()).tier);
                    }
                    if (!isQuantityModifier && be.getSpeedTier() == SpeedModifierItem.SpeedTier.ZERO) {
                        modifierAdded = be.setSpeedTier(((SpeedModifierItem)heldStack.getItem()).tier);
                    }
                    if (modifierAdded && !player.isCreative()) {
                        heldStack.shrink(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkEmitterBlockEntity) {
            SculkEmitterBlockEntity be = (SculkEmitterBlockEntity)blockEntity;
            if (player.isShiftKeyDown()) {
                Direction clickedFace = hit.getDirection();
                Direction emitterFacing = (Direction)state.getValue((Property)FACING);
                if (!clickedFace.getAxis().test(emitterFacing)) {
                    if (!level.isClientSide()) {
                        Vector3f rotatedHitVec = hit.getLocation().subtract(pos.getCenter()).toVector3f().rotate((Quaternionfc)emitterFacing.getRotation().invert());
                        float hitCheck = rotatedHitVec.x == 0.5f ? rotatedHitVec.z : (rotatedHitVec.x == -0.5f ? -rotatedHitVec.z : (rotatedHitVec.z == 0.5f ? -rotatedHitVec.x : rotatedHitVec.x));
                        this.removeModifer(player, be, hitCheck < 0.0f);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }

    private void removeModifer(Player player, SculkEmitterBlockEntity be, boolean removeQuantityModifier) {
        Enum modifierTier;
        if (removeQuantityModifier) {
            modifierTier = be.getQuantityTier();
            be.removeQuantityModifier();
        } else {
            modifierTier = be.getSpeedTier();
            be.removeSpeedModifier();
        }
        player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)modifierTier.getItem()));
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos fromPos, BlockState fromState, RandomSource random) {
        BlockEntity blockEntity;
        if (fromPos.equals((Object)pos.relative(((Direction)state.getValue((Property)FACING)).getOpposite())) && (blockEntity = level.getBlockEntity(pos)) instanceof SculkEmitterBlockEntity) {
            SculkEmitterBlockEntity be = (SculkEmitterBlockEntity)blockEntity;
            BlockState stateBelow = level.getBlockState(fromPos);
            if (be.getLastKnownStateBelow() != stateBelow) {
                be.setLastKnownStateBelow(stateBelow);
            }
        }
        return super.updateShape(state, level, tickAccess, pos, direction, fromPos, fromState, random);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean stillInside) {
        if (entity instanceof ItemEntity) {
            SculkEmitterBlockEntity be;
            ItemEntity item = (ItemEntity)entity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SculkEmitterBlockEntity && !(be = (SculkEmitterBlockEntity)blockEntity).hasStoredItemSignal() && !be.canExtractFromBelow()) {
                ItemStack extracted = item.getItem().split(be.getAmountToExtract());
                be.setItemSignal(new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), extracted), 15);
                if (item.getItem().isEmpty() && level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    item.kill(serverLevel);
                }
            }
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SculkEmitterBlockEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? SculkEmitterBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)STBlockEntityTypes.SCULK_EMITTER_BLOCK_ENTITY.get()), SculkEmitterBlockEntity::serverTick) : null;
    }
}

