/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.blocks;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sculktransporting.STTags;
import sculktransporting.blockentities.SculkReceiverBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;

public class SculkReceiverBlock
extends BaseSculkItemTransporterBlock {
    public SculkReceiverBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.upShape = Stream.of(Block.box((double)6.0, (double)1.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.box((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)1.0, (double)9.0), Block.box((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)3.0, (double)1.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)1.0, (double)3.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)15.0, (double)16.0, (double)3.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        this.downShape = Stream.of(Block.box((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.box((double)15.0, (double)13.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)13.0, (double)15.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)13.0, (double)0.0, (double)1.0, (double)16.0, (double)1.0), Block.box((double)15.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        this.northShape = Stream.of(Block.box((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)15.0), Block.box((double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)9.0, (double)16.0), Block.box((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)11.0, (double)14.0), Block.box((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)13.0), Block.box((double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)1.0, (double)16.0), Block.box((double)0.0, (double)15.0, (double)13.0, (double)1.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)15.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        this.eastShape = Stream.of(Block.box((double)1.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0), Block.box((double)0.0, (double)7.0, (double)7.0, (double)1.0, (double)9.0, (double)9.0), Block.box((double)2.0, (double)5.0, (double)5.0, (double)3.0, (double)11.0, (double)11.0), Block.box((double)3.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0), Block.box((double)0.0, (double)15.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0), Block.box((double)0.0, (double)0.0, (double)15.0, (double)3.0, (double)1.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        this.southShape = Stream.of(Block.box((double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)10.0, (double)2.0), Block.box((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)1.0), Block.box((double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0, (double)3.0), Block.box((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)8.0), Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)3.0), Block.box((double)15.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)15.0, (double)0.0, (double)1.0, (double)16.0, (double)3.0), Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)3.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        this.westShape = Stream.of(Block.box((double)14.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0, (double)10.0), Block.box((double)15.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0), Block.box((double)13.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0), Block.box((double)8.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0), Block.box((double)13.0, (double)15.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0), Block.box((double)13.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)1.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public InteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkReceiverBlockEntity) {
            SculkReceiverBlockEntity be = (SculkReceiverBlockEntity)blockEntity;
            if (heldStack.is(STTags.Items.SPEED_MODIFIERS)) {
                if (!level.isClientSide() && be.getSpeedTier() == SpeedModifierItem.SpeedTier.ZERO && be.setSpeedTier(((SpeedModifierItem)heldStack.getItem()).tier) && !player.isCreative()) {
                    heldStack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof SculkReceiverBlockEntity) {
            SculkReceiverBlockEntity be = (SculkReceiverBlockEntity)blockEntity;
            if (player.isShiftKeyDown()) {
                if (!level.isClientSide()) {
                    SpeedModifierItem.SpeedTier speedTier = be.getSpeedTier();
                    be.removeSpeedModifier();
                    player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)speedTier.getItem()));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SculkReceiverBlockEntity(pos, state);
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return !level.isClientSide() ? SculkReceiverBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)STBlockEntityTypes.SCULK_RECEIVER_BLOCK_ENTITY.get()), SculkReceiverBlockEntity::serverTick) : null;
    }
}

