/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import com.mojang.math.Quadrant;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.data.AtlasIds;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.model.data.ModelProperty;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.ItemSignalParticle;
import sculktransporting.client.SculkEmitterModel;
import sculktransporting.client.SculkItemTransporterBlockEntityRenderer;
import sculktransporting.client.SculkReceiverModel;
import sculktransporting.client.SculkTransmitterBlockEntityRenderer;
import sculktransporting.items.ModifierTier;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;
import sculktransporting.registration.STBlockEntityTypes;
import sculktransporting.registration.STBlocks;
import sculktransporting.registration.STParticleTypes;

@EventBusSubscriber(modid="sculktransporting", value={Dist.CLIENT})
public class ClientHandler {
    public static final ModelProperty<SpeedModifierItem.SpeedTier> SPEED_TIER = new ModelProperty();
    public static final ModelProperty<QuantityModifierItem.QuantityTier> QUANTITY_TIER = new ModelProperty();

    private ClientHandler() {
    }

    @SubscribeEvent
    public static void onModelBakingCompleted(ModelEvent.ModifyBakingResult event) {
        Map models = event.getBakingResult().blockStateModels();
        ClientHandler.replaceModels(models, (Block)STBlocks.SCULK_RECEIVER.get(), SculkReceiverModel::new);
        ClientHandler.replaceModels(models, (Block)STBlocks.SCULK_EMITTER.get(), SculkEmitterModel::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)STBlockEntityTypes.SCULK_EMITTER_BLOCK_ENTITY.get(), SculkItemTransporterBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)STBlockEntityTypes.SCULK_TRANSMITTER_BLOCK_ENTITY.get(), SculkTransmitterBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)STBlockEntityTypes.SCULK_RECEIVER_BLOCK_ENTITY.get(), SculkItemTransporterBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpecial((ParticleType)STParticleTypes.ITEM_SIGNAL.get(), (ParticleProvider)new ItemSignalParticle.Provider());
    }

    private static void replaceModels(Map<BlockState, BlockStateModel> models, Block block, BiFunction<BlockStateModel, Direction, BlockStateModel> modelFactory) {
        for (BlockState state : block.getStateDefinition().getPossibleStates()) {
            models.put(state, modelFactory.apply(models.get(state), (Direction)state.getValue(BaseSculkItemTransporterBlock.FACING)));
        }
    }

    public static BakedQuad bakeQuad(Direction quadDirection, Direction modelDirection, String blockName, Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad, float u0, float v0, float u1, float v1) {
        TextureAtlasSprite sprite = Minecraft.getInstance().getAtlasManager().getAtlasOrThrow(AtlasIds.BLOCKS).getSprite(ResourceLocation.fromNamespaceAndPath((String)"sculktransporting", (String)("block/" + blockName + "_side_" + modifierTier.getValue())));
        return FaceBakery.bakeQuad((Vector3fc)from, (Vector3fc)to, (BlockElementFace)new BlockElementFace(null, originalQuad.tintIndex(), sprite.contents().name().toString(), new BlockElementFace.UVs(u0, v0, u1, v1), Quadrant.R0), (TextureAtlasSprite)sprite, (Direction)quadDirection, (ModelState)ClientHandler.getModelRotation(modelDirection), null, (boolean)originalQuad.shade(), (int)0);
    }

    private static BlockModelRotation getModelRotation(Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> BlockModelRotation.X180_Y0;
            case Direction.UP -> BlockModelRotation.X0_Y0;
            case Direction.NORTH -> BlockModelRotation.X90_Y0;
            case Direction.SOUTH -> BlockModelRotation.X90_Y180;
            case Direction.WEST -> BlockModelRotation.X90_Y270;
            case Direction.EAST -> BlockModelRotation.X90_Y90;
        };
    }
}

