/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.BreakingItemParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import sculktransporting.client.ItemSignalParticleOption;

public class ItemSignalParticle
extends BreakingItemParticle {
    private final PositionSource target;

    public ItemSignalParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, PositionSource target, int lifetime, TextureAtlasSprite sprite) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed, sprite);
        this.x += this.xd;
        this.y += this.yd;
        this.z += this.zd;
        this.target = target;
        this.lifetime = lifetime;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            Optional optional = this.target.getPosition((Level)this.level);
            if (optional.isEmpty()) {
                this.remove();
            } else {
                int aliveTime = this.lifetime - this.age;
                double delta = 1.0 / (double)aliveTime;
                Vec3 targetPos = ((Vec3)optional.get()).add(this.xd, this.yd, this.zd);
                double x = Mth.lerp((double)delta, (double)this.x, (double)targetPos.x());
                double y = Mth.lerp((double)delta, (double)this.y, (double)targetPos.y());
                double z = Mth.lerp((double)delta, (double)this.z, (double)targetPos.z());
                this.setPos(x, y, z);
            }
        }
    }

    public static class Provider
    extends BreakingItemParticle.ItemParticleProvider<ItemSignalParticleOption> {
        public Particle createParticle(ItemSignalParticleOption type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, RandomSource random) {
            return new ItemSignalParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, type.destination(), type.arrivalInTicks(), this.getSprite(type.stack(), level, random));
        }
    }
}

