/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.model.data.ModelData;
import sculktransporting.client.ClientHandler;
import sculktransporting.client.SculkEmitterModelPart;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;

public class SculkEmitterModel
implements BlockStateModel {
    private final BlockStateModel originalModel;
    private final Direction blockStateFacing;
    private final Map<Pair<SpeedModifierItem.SpeedTier, QuantityModifierItem.QuantityTier>, SculkEmitterModelPart> modelPartCache = new ConcurrentHashMap<Pair<SpeedModifierItem.SpeedTier, QuantityModifierItem.QuantityTier>, SculkEmitterModelPart>();

    public SculkEmitterModel(BlockStateModel originalModel, Direction blockStateFacing) {
        this.originalModel = originalModel;
        this.blockStateFacing = blockStateFacing;
    }

    public void collectParts(BlockAndTintGetter level, BlockPos pos, BlockState state, RandomSource random, List<BlockModelPart> parts) {
        ModelData data = level.getModelData(pos);
        SpeedModifierItem.SpeedTier speedTier = (SpeedModifierItem.SpeedTier)data.get(ClientHandler.SPEED_TIER);
        QuantityModifierItem.QuantityTier quantityTier = (QuantityModifierItem.QuantityTier)data.get(ClientHandler.QUANTITY_TIER);
        if (speedTier != null && quantityTier != null) {
            for (BlockModelPart oldModelPart : this.originalModel.collectParts(level, pos, state, random)) {
                SculkEmitterModelPart newModelPart = this.modelPartCache.computeIfAbsent((Pair<SpeedModifierItem.SpeedTier, QuantityModifierItem.QuantityTier>)Pair.of((Object)speedTier, (Object)quantityTier), k -> new SculkEmitterModelPart(oldModelPart, this.blockStateFacing, speedTier, quantityTier));
                parts.add(newModelPart);
            }
            return;
        }
        parts.addAll(this.originalModel.collectParts(level, pos, state, random));
    }

    public void collectParts(RandomSource random, List<BlockModelPart> modelList) {
        modelList.addAll(this.originalModel.collectParts(random));
    }

    public TextureAtlasSprite particleIcon(BlockAndTintGetter level, BlockPos pos, BlockState state) {
        return this.originalModel.particleIcon(level, pos, state);
    }

    public TextureAtlasSprite particleIcon() {
        return this.originalModel.particleIcon();
    }
}

