/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.ModifierTier;
import sculktransporting.items.QuantityModifierItem;
import sculktransporting.items.SpeedModifierItem;

public record SculkEmitterModelPart(BlockModelPart originalModel, Direction modelDirection, SpeedModifierItem.SpeedTier speedTier, QuantityModifierItem.QuantityTier quantityTier) implements BlockModelPart
{
    public List<BakedQuad> getQuads(Direction side) {
        ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.originalModel.getQuads(side));
        if (side != null) {
            for (int i = 0; i < originalQuads.size(); ++i) {
                BakedQuad quad = (BakedQuad)originalQuads.get(i);
                if (!quad.isTinted()) continue;
                int tintIndex = quad.tintIndex();
                if (tintIndex == 0) {
                    originalQuads.set(i, this.bakeLeftQuad(Direction.NORTH, new Vector3f(8.0f, 0.0f, 0.0f), new Vector3f(16.0f, 8.0f, 0.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex == 1) {
                    originalQuads.set(i, this.bakeRightQuad(Direction.NORTH, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(8.0f, 8.0f, 0.0f), this.quantityTier, quad));
                    continue;
                }
                if (tintIndex == 2) {
                    originalQuads.set(i, this.bakeLeftQuad(Direction.EAST, new Vector3f(16.0f, 0.0f, 8.0f), new Vector3f(16.0f, 8.0f, 16.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex == 3) {
                    originalQuads.set(i, this.bakeRightQuad(Direction.EAST, new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(16.0f, 8.0f, 8.0f), this.quantityTier, quad));
                    continue;
                }
                if (tintIndex == 4) {
                    originalQuads.set(i, this.bakeLeftQuad(Direction.SOUTH, new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(8.0f, 8.0f, 16.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex == 5) {
                    originalQuads.set(i, this.bakeRightQuad(Direction.SOUTH, new Vector3f(8.0f, 0.0f, 16.0f), new Vector3f(16.0f, 8.0f, 16.0f), this.quantityTier, quad));
                    continue;
                }
                if (tintIndex == 6) {
                    originalQuads.set(i, this.bakeLeftQuad(Direction.WEST, new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 8.0f, 8.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex != 7) continue;
                originalQuads.set(i, this.bakeRightQuad(Direction.WEST, new Vector3f(0.0f, 0.0f, 8.0f), new Vector3f(0.0f, 8.0f, 16.0f), this.quantityTier, quad));
            }
        }
        return originalQuads;
    }

    private BakedQuad bakeLeftQuad(Direction quadDirection, Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad) {
        return this.bakeQuad(quadDirection, from, to, modifierTier, originalQuad, 0.0f, 8.0f, 8.0f, 16.0f);
    }

    private BakedQuad bakeRightQuad(Direction quadDirection, Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad) {
        return this.bakeQuad(quadDirection, from, to, modifierTier, originalQuad, 8.0f, 8.0f, 16.0f, 16.0f);
    }

    private BakedQuad bakeQuad(Direction quadDirection, Vector3f from, Vector3f to, ModifierTier modifierTier, BakedQuad originalQuad, float u0, float u1, float v0, float v1) {
        return ClientHandler.bakeQuad(quadDirection, this.modelDirection, "sculk_emitter", from, to, modifierTier, originalQuad, u0, u1, v0, v1);
    }

    public ChunkSectionLayer getRenderType(BlockState state) {
        return ChunkSectionLayer.CUTOUT;
    }

    public boolean useAmbientOcclusion() {
        return this.originalModel.useAmbientOcclusion();
    }

    public TextureAtlasSprite particleIcon() {
        return this.originalModel.particleIcon();
    }
}

