/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.blocks.BaseSculkItemTransporterBlock;
import sculktransporting.client.SculkItemTransporterRenderState;

public class SculkItemTransporterBlockEntityRenderer<T extends BaseSculkItemTransporterBlockEntity, S extends SculkItemTransporterRenderState>
implements BlockEntityRenderer<T, S> {
    private static final Quaternionf XP_90 = new Quaternionf().rotateXYZ(1.5707964f, 0.0f, 0.0f);
    protected final ItemModelResolver itemModelResolver;
    private final RandomSource random = RandomSource.create();

    public SculkItemTransporterBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemModelResolver = ctx.itemModelResolver();
    }

    public void submit(S state, PoseStack pose, SubmitNodeCollector submitNodeCollector, CameraRenderState camera) {
        if (((SculkItemTransporterRenderState)((Object)state)).hasStoredItemSignal) {
            pose.pushPose();
            this.adjustForRotation(pose, ((SculkItemTransporterRenderState)((Object)state)).rotation);
            if (((SculkItemTransporterRenderState)((Object)state)).itemClusterRenderState.item.getModelBoundingBox().getZsize() <= 0.0625) {
                pose.translate(0.5, 0.52, 0.375);
                pose.mulPose((Quaternionfc)XP_90);
            } else {
                pose.translate(0.5, 0.63, 0.5);
            }
            pose.scale(0.5f, 0.5f, 0.5f);
            ItemEntityRenderer.renderMultipleFromCount((PoseStack)pose, (SubmitNodeCollector)submitNodeCollector, (int)((SculkItemTransporterRenderState)((Object)state)).lightCoords, (ItemClusterRenderState)((SculkItemTransporterRenderState)((Object)state)).itemClusterRenderState, (RandomSource)this.random);
            pose.popPose();
        }
    }

    public S createRenderState() {
        return (S)((Object)new SculkItemTransporterRenderState());
    }

    public void extractRenderState(T be, S state, float partialTick, Vec3 cameraPosition, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        ((SculkItemTransporterRenderState)((Object)state)).hasStoredItemSignal = ((BaseSculkItemTransporterBlockEntity)((Object)be)).hasStoredItemSignal();
        if (((SculkItemTransporterRenderState)((Object)state)).hasStoredItemSignal) {
            ItemStack signal = ((BaseSculkItemTransporterBlockEntity)((Object)be)).getStoredItemSignal();
            this.itemModelResolver.updateForTopItem(((SculkItemTransporterRenderState)((Object)state)).itemClusterRenderState.item, signal, ItemDisplayContext.FIXED, be.getLevel(), null, ItemClusterRenderState.getSeedForItemStack((ItemStack)signal));
            ((SculkItemTransporterRenderState)((Object)state)).itemClusterRenderState.count = ItemClusterRenderState.getRenderedAmount((int)signal.getCount());
            ((SculkItemTransporterRenderState)((Object)state)).itemClusterRenderState.seed = ItemClusterRenderState.getSeedForItemStack((ItemStack)signal);
        }
        ((SculkItemTransporterRenderState)((Object)state)).rotation = ((Direction)be.getBlockState().getValue(BaseSculkItemTransporterBlock.FACING)).getRotation();
        super.extractRenderState(be, state, partialTick, cameraPosition, breakProgress);
    }

    protected void adjustForRotation(PoseStack pose, Quaternionfc rotation) {
        pose.translate(0.5, 0.5, 0.5);
        pose.mulPose(rotation);
        pose.translate(-0.5, -0.5, -0.5);
    }
}

