/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Vector3f;
import sculktransporting.client.ClientHandler;
import sculktransporting.items.SpeedModifierItem;

public record SculkReceiverModelPart(BlockModelPart originalModel, Direction modelDirection, SpeedModifierItem.SpeedTier speedTier) implements BlockModelPart
{
    public List<BakedQuad> getQuads(Direction side) {
        ArrayList<BakedQuad> originalQuads = new ArrayList<BakedQuad>(this.originalModel.getQuads(side));
        if (side != null) {
            for (int i = 0; i < originalQuads.size(); ++i) {
                BakedQuad quad = (BakedQuad)originalQuads.get(i);
                if (!quad.isTinted()) continue;
                int tintIndex = quad.tintIndex();
                if (tintIndex == 0) {
                    originalQuads.set(i, this.bakeQuad(Direction.NORTH, new Vector3f(0.0f, 3.0f, 0.0f), new Vector3f(16.0f, 8.0f, 0.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex == 1) {
                    originalQuads.set(i, this.bakeQuad(Direction.EAST, new Vector3f(16.0f, 3.0f, 0.0f), new Vector3f(16.0f, 8.0f, 16.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex == 2) {
                    originalQuads.set(i, this.bakeQuad(Direction.SOUTH, new Vector3f(0.0f, 3.0f, 16.0f), new Vector3f(16.0f, 8.0f, 16.0f), this.speedTier, quad));
                    continue;
                }
                if (tintIndex != 3) continue;
                originalQuads.set(i, this.bakeQuad(Direction.WEST, new Vector3f(0.0f, 3.0f, 0.0f), new Vector3f(0.0f, 8.0f, 16.0f), this.speedTier, quad));
            }
        }
        return originalQuads;
    }

    private BakedQuad bakeQuad(Direction quadDirection, Vector3f from, Vector3f to, SpeedModifierItem.SpeedTier speedTier, BakedQuad originalQuad) {
        return ClientHandler.bakeQuad(quadDirection, this.modelDirection, "sculk_receiver", from, to, speedTier, originalQuad, 0.0f, 8.0f, 16.0f, 13.0f);
    }

    public ChunkSectionLayer getRenderType(BlockState state) {
        return ChunkSectionLayer.CUTOUT;
    }

    public boolean useAmbientOcclusion() {
        return this.originalModel.useAmbientOcclusion();
    }

    public TextureAtlasSprite particleIcon() {
        return this.originalModel.particleIcon();
    }
}

