/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;
import sculktransporting.blockentities.SculkTransmitterBlockEntity;
import sculktransporting.client.SculkItemTransporterBlockEntityRenderer;
import sculktransporting.client.SculkTransmitterRenderState;

public class SculkTransmitterBlockEntityRenderer
extends SculkItemTransporterBlockEntityRenderer<SculkTransmitterBlockEntity, SculkTransmitterRenderState> {
    public SculkTransmitterBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Override
    public void submit(SculkTransmitterRenderState state, PoseStack pose, SubmitNodeCollector submitNodeCollector, CameraRenderState camera) {
        super.submit(state, pose, submitNodeCollector, camera);
        if (state.hasFilter) {
            pose.pushPose();
            this.adjustForRotation(pose, state.rotation);
            pose.translate(1.0f, 0.25f, 1.0f);
            this.renderItem(state, pose, -0.5f, 0.0f, -1.0f, 0.0f, submitNodeCollector);
            this.renderItem(state, pose, -1.0f, 0.0f, -0.5f, 90.0f, submitNodeCollector);
            this.renderItem(state, pose, -0.5f, 0.0f, 0.0f, 180.0f, submitNodeCollector);
            this.renderItem(state, pose, 0.0f, 0.0f, -0.5f, 270.0f, submitNodeCollector);
            pose.popPose();
        }
    }

    @Override
    public SculkTransmitterRenderState createRenderState() {
        return new SculkTransmitterRenderState();
    }

    @Override
    public void extractRenderState(SculkTransmitterBlockEntity be, SculkTransmitterRenderState state, float partialTick, Vec3 cameraPosition, ModelFeatureRenderer.CrumblingOverlay breakProgress) {
        ItemStack filteredItem = be.getFilteredItem();
        boolean bl = state.hasFilter = !filteredItem.isEmpty();
        if (state.hasFilter) {
            this.itemModelResolver.updateForTopItem(state.filter, filteredItem, ItemDisplayContext.FIXED, be.getLevel(), null, ItemClusterRenderState.getSeedForItemStack((ItemStack)filteredItem));
        }
        super.extractRenderState(be, state, partialTick, cameraPosition, breakProgress);
    }

    private void renderItem(SculkTransmitterRenderState state, PoseStack pose, float translateX, float translateY, float translateZ, float degrees, SubmitNodeCollector submitNodeCollector) {
        pose.pushPose();
        pose.translate(translateX, translateY, translateZ);
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(degrees));
        pose.scale(0.35f, 0.35f, 0.35f);
        state.filter.submit(pose, submitNodeCollector, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        pose.popPose();
    }
}

