/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.misc;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class OneReceiverVibrationListener
extends VibrationSystem.Listener {
    public OneReceiverVibrationListener(VibrationSystem system) {
        super(system);
    }

    public void scheduleVibration(ServerLevel level, VibrationSystem.Data data, Holder<GameEvent> gameEvent, GameEvent.Context ctx, Vec3 from, Vec3 to) {
        Entity entity;
        VibrationInfo oldVibrationInfo;
        Optional oldVibrationData = data.getSelectionStrategy().currentVibrationData;
        super.scheduleVibration(level, data, gameEvent, ctx, from, to);
        Optional newVibrationData = data.getSelectionStrategy().currentVibrationData;
        if (oldVibrationData.isPresent() && (oldVibrationInfo = (VibrationInfo)((Pair)oldVibrationData.get()).getLeft()).distance() == (float)from.distanceTo(to) && oldVibrationInfo.entity() == null && ctx.sourceEntity() != null) {
            data.getSelectionStrategy().currentVibrationData = Optional.of(Pair.of((Object)new VibrationInfo(oldVibrationInfo.gameEvent(), oldVibrationInfo.distance(), oldVibrationInfo.pos(), ctx.sourceEntity()), (Object)level.getGameTime()));
            newVibrationData = data.getSelectionStrategy().currentVibrationData;
        }
        if ((entity = ctx.sourceEntity()) instanceof ItemEntity) {
            ItemEntity item = (ItemEntity)entity;
            if (newVibrationData.isPresent() && item.equals((Object)((VibrationInfo)((Pair)newVibrationData.get()).getLeft()).entity())) {
                Entity entity2;
                item.discard();
                if (oldVibrationData.isPresent() && (entity2 = ((VibrationInfo)((Pair)oldVibrationData.get()).getLeft()).entity()) instanceof ItemEntity) {
                    ItemEntity oldItem = (ItemEntity)entity2;
                    if (!((VibrationInfo)((Pair)oldVibrationData.get()).getLeft()).equals(((Pair)newVibrationData.get()).getLeft())) {
                        oldItem.revive();
                    }
                }
            }
        }
    }

    public GameEventListener.DeliveryMode getDeliveryMode() {
        return GameEventListener.DeliveryMode.BY_DISTANCE;
    }

    public VibrationSystem getSystem() {
        return this.system;
    }
}

