/*
 * Decompiled with CFR 0.152.
 */
package sculktransporting.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.core.Holder;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import sculktransporting.blockentities.BaseSculkItemTransporterBlockEntity;
import sculktransporting.misc.OneReceiverVibrationListener;
import sculktransporting.registration.STGameEvents;

@Mixin(value={GameEvent.ListenerInfo.class})
public class GameEventListenerInfoMixin {
    @Shadow
    @Final
    private GameEventListener recipient;
    @Shadow
    @Final
    private Holder<GameEvent> gameEvent;

    @WrapOperation(method={"compareTo"}, at={@At(value="INVOKE", target="Ljava/lang/Double;compare(DD)I")})
    public int sculktransporting$compareListeners(double thisDistance, double otherDistance, Operation<Integer> original, GameEvent.ListenerInfo other) {
        GameEventListener gameEventListener;
        if (thisDistance == otherDistance && this.gameEvent.is(STGameEvents.ITEM_TRANSMITTABLE) && (gameEventListener = this.recipient) instanceof OneReceiverVibrationListener) {
            OneReceiverVibrationListener thisListener = (OneReceiverVibrationListener)gameEventListener;
            gameEventListener = other.recipient();
            if (gameEventListener instanceof OneReceiverVibrationListener) {
                OneReceiverVibrationListener otherListener = (OneReceiverVibrationListener)gameEventListener;
                VibrationSystem vibrationSystem = thisListener.getSystem();
                if (vibrationSystem instanceof BaseSculkItemTransporterBlockEntity) {
                    BaseSculkItemTransporterBlockEntity thisBe = (BaseSculkItemTransporterBlockEntity)vibrationSystem;
                    vibrationSystem = otherListener.getSystem();
                    if (vibrationSystem instanceof BaseSculkItemTransporterBlockEntity) {
                        BaseSculkItemTransporterBlockEntity otherBe = (BaseSculkItemTransporterBlockEntity)vibrationSystem;
                        return Long.compare(thisBe.getPlacedDownTick(), otherBe.getPlacedDownTick());
                    }
                }
            }
        }
        return (Integer)original.call(new Object[]{thisDistance, otherDistance});
    }
}

