/*
 * Decompiled with CFR 0.152.
 */
package deserttomb.init;

import deserttomb.entity.MummyEntity;
import deserttomb.entity.PharaohMummyEntity;
import deserttomb.entity.ScorpionEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DesertTombModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"desert_tomb");
    public static final DeferredHolder<EntityType<?>, EntityType<ScorpionEntity>> SCORPION = DesertTombModEntities.register("scorpion", EntityType.Builder.of(ScorpionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(48).setUpdateInterval(3).sized(1.4f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<MummyEntity>> MUMMY = DesertTombModEntities.register("mummy", EntityType.Builder.of(MummyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<PharaohMummyEntity>> PHARAOH_MUMMY = DesertTombModEntities.register("pharaoh_mummy", EntityType.Builder.of(PharaohMummyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        ScorpionEntity.init(event);
        MummyEntity.init(event);
        PharaohMummyEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCORPION.get(), ScorpionEntity.createAttributes().build());
        event.put((EntityType)MUMMY.get(), MummyEntity.createAttributes().build());
        event.put((EntityType)PHARAOH_MUMMY.get(), PharaohMummyEntity.createAttributes().build());
    }
}

