/*
 * Decompiled with CFR 0.152.
 */
package deserttomb.init;

import deserttomb.entity.MummyEntity;
import deserttomb.entity.PharaohMummyEntity;
import deserttomb.entity.ScorpionEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DesertTombModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"desert_tomb");
    public static final RegistryObject<EntityType<ScorpionEntity>> SCORPION = DesertTombModEntities.register("scorpion", EntityType.Builder.m_20704_(ScorpionEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(48).setUpdateInterval(3).setCustomClientFactory(ScorpionEntity::new).m_20699_(1.4f, 0.9f));
    public static final RegistryObject<EntityType<MummyEntity>> MUMMY = DesertTombModEntities.register("mummy", EntityType.Builder.m_20704_(MummyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(MummyEntity::new).m_20699_(0.6f, 1.9f));
    public static final RegistryObject<EntityType<PharaohMummyEntity>> PHARAOH_MUMMY = DesertTombModEntities.register("pharaoh_mummy", EntityType.Builder.m_20704_(PharaohMummyEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(PharaohMummyEntity::new).m_20699_(0.6f, 1.8f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ScorpionEntity.init();
            MummyEntity.init();
            PharaohMummyEntity.init();
        });
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)SCORPION.get(), ScorpionEntity.createAttributes().m_22265_());
        event.put((EntityType)MUMMY.get(), MummyEntity.createAttributes().m_22265_());
        event.put((EntityType)PHARAOH_MUMMY.get(), PharaohMummyEntity.createAttributes().m_22265_());
    }
}

