/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.api.math;

import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class MatrixMath {
    public static final Matrix4f TRANSLATION_CENTER = MatrixMath.translation(0.5f, 0.5f, 0.5f);
    public static final Matrix4f TRANSLATION_RESET = MatrixMath.translation(-0.5f, -0.5f, -0.5f);

    public static Matrix4f translation(float tX, float tY, float tZ) {
        return MatrixMath.m4FromArray(new float[][]{{1.0f, 0.0f, 0.0f, tX}, {0.0f, 1.0f, 0.0f, tY}, {0.0f, 0.0f, 1.0f, tZ}, {0.0f, 0.0f, 0.0f, 1.0f}}).assume(2);
    }

    public static Matrix4f scale(float tX, float tY, float tZ) {
        return MatrixMath.m4FromArray(new float[][]{{tX, 0.0f, 0.0f, 0.0f}, {0.0f, tY, 0.0f, 0.0f}, {0.0f, 0.0f, tZ, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f}}).assume(2);
    }

    public static Matrix3f rotationX(float t) {
        return MatrixMath.m3FromArray(new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, (float)Math.cos(t), (float)(-Math.sin(t))}, {0.0f, (float)Math.sin(t), (float)Math.cos(t)}});
    }

    public static Matrix3f rotationY(float t) {
        return MatrixMath.m3FromArray(new float[][]{{(float)Math.cos(t), 0.0f, (float)Math.sin(t)}, {0.0f, 1.0f, 0.0f}, {(float)(-Math.sin(t)), 0.0f, (float)Math.cos(t)}});
    }

    public static Matrix3f rotationZ(float t) {
        return MatrixMath.m3FromArray(new float[][]{{(float)Math.cos(t), (float)(-Math.sin(t)), 0.0f}, {(float)Math.sin(t), (float)Math.cos(t), 0.0f}, {0.0f, 0.0f, 1.0f}});
    }

    public static Matrix4f combine(Matrix4f ... matrices) {
        Matrix4f result = null;
        for (Matrix4f matrix : matrices) {
            if (result == null) {
                result = new Matrix4f((Matrix4fc)matrix);
                continue;
            }
            result.mul((Matrix4fc)matrix);
        }
        return result;
    }

    public static Matrix4f combineAndExpand(Matrix3f ... matrices) {
        Matrix3f result = null;
        for (Matrix3f matrix : matrices) {
            if (result == null) {
                result = new Matrix3f((Matrix3fc)matrix);
                continue;
            }
            result.mul((Matrix3fc)matrix);
        }
        Matrix4f m4 = new Matrix4f().assume(2);
        m4.set(result);
        return m4;
    }

    public static Matrix3f m3FromArray(float[][] arr) {
        Matrix3f m = new Matrix3f();
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 3; ++c) {
                m.set(c, r, arr[r][c]);
            }
        }
        return m;
    }

    public static Matrix4f m4FromArray(float[][] arr) {
        Matrix4f m = new Matrix4f();
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                m.set(c, r, arr[r][c]);
            }
        }
        return m;
    }

    public static Matrix4f newAffineM4() {
        return new Matrix4f().assume(2);
    }
}

