/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.folia;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class FoliaUtil {
    private static final boolean IS_FOLIA = FoliaUtil.classExists("io.papermc.paper.threadedregions.RegionizedServer") || FoliaUtil.classExists("io.papermc.paper.threadedregions.RegionizedServerInitEvent");

    public static boolean isFolia() {
        return IS_FOLIA;
    }

    public static void runIfFolia(Runnable runFolia, Runnable runElse) {
        if (FoliaUtil.isFolia()) {
            runFolia.run();
        } else {
            runElse.run();
        }
    }

    public static void scheduleOnEntity(JavaPlugin plugin, Entity entity, Runnable runnable, int delay) {
        entity.getScheduler().execute((Plugin)plugin, runnable, null, (long)delay);
    }

    public static void scheduleOnServer(JavaPlugin plugin, Runnable runnable) {
        Bukkit.getServer().getGlobalRegionScheduler().execute((Plugin)plugin, runnable);
    }

    private static boolean classExists(String clazz) {
        try {
            Class.forName(clazz);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

