/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin;

import dev.cerus.visualcrafting.api.config.Config;
import dev.cerus.visualcrafting.api.version.VersionAdapter;
import dev.cerus.visualcrafting.folia.FoliaUtil;
import dev.cerus.visualcrafting.lib.bstats.bukkit.Metrics;
import dev.cerus.visualcrafting.lib.bstats.charts.SimplePie;
import dev.cerus.visualcrafting.plugin.listener.CancelCraftingListener;
import dev.cerus.visualcrafting.plugin.listener.CraftingInventoryInteractListener;
import dev.cerus.visualcrafting.plugin.listener.PlayerJoinListener;
import dev.cerus.visualcrafting.plugin.listener.PreItemCraftListener;
import dev.cerus.visualcrafting.plugin.texture.TextureCache;
import dev.cerus.visualcrafting.plugin.texture.TextureDownloader;
import dev.cerus.visualcrafting.plugin.visualizer.DisplayVisualizationController;
import dev.cerus.visualcrafting.plugin.visualizer.MapVisualizationController;
import dev.cerus.visualcrafting.plugin.visualizer.VisualizationController;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class VisualCraftingPlugin
extends JavaPlugin
implements Config {
    public void onEnable() {
        DisplayVisualizationController visualizationController;
        VersionAdapter versionAdapter;
        this.saveDefaultConfig();
        String version = Bukkit.getVersion();
        version = version.substring(version.indexOf("MC: ") + 4, version.lastIndexOf(41));
        if (!version.matches("\\d+\\.\\d+(\\.\\d+)?")) {
            this.getLogger().severe("Could not detect server version for " + version);
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        String minor = version.split("\\.")[1];
        switch (version) {
            case "1.16.5": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("16R3");
                break;
            }
            case "1.17": 
            case "1.17.1": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("17R1");
                break;
            }
            case "1.18.1": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("18R1");
                break;
            }
            case "1.18.2": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("18R2");
                break;
            }
            case "1.19": 
            case "1.19.1": 
            case "1.19.2": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("19R1");
                break;
            }
            case "1.19.3": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("19R2");
                break;
            }
            case "1.19.4": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("19R3");
                break;
            }
            case "1.20": 
            case "1.20.1": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("20R1");
                break;
            }
            case "1.20.2": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("20R2");
                break;
            }
            case "1.20.3": 
            case "1.20.4": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("20R3");
                break;
            }
            case "1.20.5": 
            case "1.20.6": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("20R4");
                break;
            }
            case "1.21": 
            case "1.21.1": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("21R1");
                break;
            }
            case "1.21.2": 
            case "1.21.3": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("21R2");
                break;
            }
            case "1.21.4": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("21R3");
                break;
            }
            case "1.21.5": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("21R4");
                break;
            }
            case "1.21.6": 
            case "1.21.7": 
            case "1.21.8": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("21R5");
                break;
            }
            case "1.21.9": 
            case "1.21.10": {
                VersionAdapter versionAdapter2 = this.createVersionAdapter("21R6");
                break;
            }
            default: {
                VersionAdapter versionAdapter2 = versionAdapter = null;
            }
        }
        if (versionAdapter == null) {
            this.getLogger().severe("Unsupported server version");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        String renderType = this.getConfig().getString("rendering", "DISPLAY");
        if (renderType.equals("DISPLAY")) {
            String[] verSplit = version.split("\\.");
            int minorVer = Integer.parseInt(verSplit[1]);
            int patchVer = Integer.parseInt(verSplit.length == 3 ? verSplit[2] : "0");
            if (minorVer < 19 || minorVer == 19 && patchVer != 4) {
                renderType = "MAP";
                this.getLogger().warning("Render style 'DISPLAY' is not supported in version %s. Falling back to 'MAP'".formatted(version));
            }
        }
        String finalRenderType = renderType;
        switch (renderType) {
            case "MAP": {
                File textureCacheFile = new File(this.getDataFolder(), "textures_" + minor);
                TextureCache textureCache = new TextureCache();
                if (textureCacheFile.exists()) {
                    textureCache.read(textureCacheFile);
                } else {
                    TextureDownloader downloader = new TextureDownloader();
                    downloader.downloadTextures(this.getLogger(), new File(this.getDataFolder(), "temp"), textureCache).whenComplete((unused, throwable) -> {
                        if (throwable != null) {
                            this.getLogger().log(Level.SEVERE, "Failed to download textures", (Throwable)throwable);
                        }
                        downloader.shutdown();
                        textureCache.write(textureCacheFile);
                    });
                }
                VisualizationController visualizationController2 = new MapVisualizationController(versionAdapter, textureCache);
                break;
            }
            case "DISPLAY": {
                VisualizationController visualizationController2 = new DisplayVisualizationController(versionAdapter);
                break;
            }
            default: {
                VisualizationController visualizationController2 = visualizationController = null;
            }
        }
        if (visualizationController == null) {
            this.getLogger().severe("Unsupported render style");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (!visualizationController.accepts(versionAdapter)) {
            this.getLogger().severe("Controller '%s' does not accept version adapter for version %s".formatted(visualizationController.getClass().getSimpleName(), version));
            this.getLogger().severe("This usually means that you're using an unsupported render style. Changing the render style to 'MAP' should resolve this issue.");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        versionAdapter.init(this, (player, integer) -> this.getServer().getScheduler().runTask((Plugin)this, () -> visualizationController.entityClick((Player)player, (int)integer)));
        versionAdapter.init(this, (player, integer) -> {
            Runnable cmd = () -> visualizationController.entityClick((Player)player, (int)integer);
            FoliaUtil.runIfFolia(() -> FoliaUtil.scheduleOnEntity(this, (Entity)player, cmd, 0), () -> this.getServer().getScheduler().runTask((Plugin)this, cmd));
        });
        this.getServer().getPluginManager().registerEvents((Listener)new CancelCraftingListener(visualizationController), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this, versionAdapter), (Plugin)this);
        if (this.getConfig().getBoolean("only-visualize-recipes", false)) {
            this.getServer().getPluginManager().registerEvents((Listener)new PreItemCraftListener(this, visualizationController), (Plugin)this);
        } else {
            this.getServer().getPluginManager().registerEvents((Listener)new CraftingInventoryInteractListener(this, visualizationController), (Plugin)this);
        }
        this.getLogger().info("Visual Crafting was enabled!");
        this.getLogger().info("Using version adapter '%s' and controller '%s'".formatted(versionAdapter.getClass().getSimpleName(), visualizationController.getClass().getSimpleName()));
        Metrics metrics = new Metrics(this, 14561);
        metrics.addCustomChart(new SimplePie("enable_permission", () -> this.getConfig().getBoolean("permission.enable", false) ? "True" : "False"));
        metrics.addCustomChart(new SimplePie("enable_hitbox", () -> this.adjustHitbox() ? "True" : "False"));
        metrics.addCustomChart(new SimplePie("enable_packet_listening", () -> this.enablePacketListening() ? "True" : "False"));
        metrics.addCustomChart(new SimplePie("render_style", () -> this.normalize(finalRenderType)));
        metrics.addCustomChart(new SimplePie("download_source", this::getDownloadSource));
    }

    public boolean canUse(Permissible permissible) {
        return !this.getConfig().getBoolean("permission.enable", false) || permissible.hasPermission(this.getConfig().getString("permission.perm", ""));
    }

    @Override
    public int entityIdRangeMin() {
        return this.getConfig().getInt("entity-id.min");
    }

    @Override
    public int entityIdRangeMax() {
        return this.getConfig().getInt("entity-id.max");
    }

    @Override
    public int mapIdRangeMin() {
        return this.getConfig().getInt("map-id.min");
    }

    @Override
    public int mapIdRangeMax() {
        return this.getConfig().getInt("map-id.max");
    }

    @Override
    public boolean adjustHitbox() {
        return this.getConfig().getBoolean("adjust-hitbox");
    }

    @Override
    public boolean enablePacketListening() {
        return this.getConfig().getBoolean("enable-packet-listening", true);
    }

    private String normalize(String s) {
        if (s.length() <= 1) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1).toLowerCase();
    }

    private VersionAdapter createVersionAdapter(String versionSlug) {
        try {
            String classPath = "dev.cerus.visualcrafting.v%s.VersionAdapter%s".formatted(versionSlug.toLowerCase(), versionSlug.toUpperCase());
            Class<?> cls = Class.forName(classPath);
            return (VersionAdapter)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "Could not create version adapter", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDownloadSource() {
        StringBuilder sourceBuilder = new StringBuilder();
        try (InputStream in = VisualCraftingPlugin.class.getClassLoader().getResourceAsStream("metadata");){
            int read;
            if (in == null) {
                String string = "unknown";
                return string;
            }
            byte[] buffer = new byte[64];
            while ((read = in.read(buffer)) != -1) {
                sourceBuilder.append(new String(buffer, 0, read));
            }
            return sourceBuilder.toString();
        }
        catch (IOException e) {
            this.getLogger().log(Level.WARNING, "Failed to read metadata file", e);
            return "unknown";
        }
    }
}

