/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.texture;

import dev.cerus.visualcrafting.plugin.texture.Texture;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextureCache {
    private final Map<String, Map<String, Texture>> textureMap = new HashMap<String, Map<String, Texture>>();

    public void write(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            for (String group : this.textureMap.keySet()) {
                out.write(ByteBuffer.allocate(4).putInt(group.length()).array());
                out.write(group.getBytes(StandardCharsets.UTF_8));
                Map<String, Texture> textures = this.textureMap.get(group);
                out.write(ByteBuffer.allocate(4).putInt(textures.size()).array());
                for (Texture texture : textures.values()) {
                    out.write(ByteBuffer.allocate(4).putInt(texture.getName().length()).array());
                    out.write(texture.getName().getBytes(StandardCharsets.UTF_8));
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            out.write(texture.get(x, y));
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void read(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            while (in.available() > 0) {
                byte[] arr = new byte[4];
                in.read(arr);
                int len = ByteBuffer.wrap(arr).getInt();
                arr = new byte[len];
                in.read(arr);
                String group = new String(arr);
                arr = new byte[4];
                in.read(arr);
                int amount = ByteBuffer.wrap(arr).getInt();
                for (int i = 0; i < amount; ++i) {
                    arr = new byte[4];
                    in.read(arr);
                    len = ByteBuffer.wrap(arr).getInt();
                    arr = new byte[len];
                    in.read(arr);
                    String name = new String(arr);
                    Texture texture = new Texture(group, name);
                    for (int x = 0; x < 16; ++x) {
                        for (int y = 0; y < 16; ++y) {
                            texture.set(x, y, (byte)in.read());
                        }
                    }
                    this.addTexture(group, name, texture);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addTexture(String group, String name, Texture texture) {
        this.textureMap.computeIfAbsent(group, s -> new HashMap()).put(name, texture);
    }

    public Texture getTexture(String group, String name) {
        if (!this.textureMap.containsKey(group)) {
            return null;
        }
        return this.textureMap.get(group).get(name);
    }

    public Collection<String> getTextureGroups() {
        return this.textureMap.keySet();
    }

    public Collection<String> getTextureNames(String group) {
        if (!this.textureMap.containsKey(group)) {
            return List.of();
        }
        return this.textureMap.get(group).keySet();
    }
}

