/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.texture;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.cerus.visualcrafting.lib.maps.api.MapColor;
import dev.cerus.visualcrafting.plugin.texture.Texture;
import dev.cerus.visualcrafting.plugin.texture.TextureCache;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;

public class TextureDownloader {
    private static final String VERSION_MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private final ExecutorService executorService;

    public TextureDownloader() {
        this(Executors.newSingleThreadScheduledExecutor());
    }

    public TextureDownloader(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public CompletableFuture<Void> downloadTextures(Logger logger, File folder, TextureCache textureCache) {
        folder.mkdirs();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.executorService.execute(() -> {
            try {
                String clientDownloadUrl;
                try {
                    clientDownloadUrl = this.getMatchingClientUrl();
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                    return;
                }
                logger.info("Downloading Minecraft textures");
                folder.mkdirs();
                File clientJar = new File(folder, "client.jar");
                Path outputPath = folder.toPath();
                try {
                    this.download(clientDownloadUrl, clientJar);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    return;
                }
                logger.info("Extracting & converting item textures");
                try {
                    this.extractAndConvert(folder, textureCache, clientJar, "item", outputPath);
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                    return;
                }
                logger.info("Extracting & converting block textures");
                try {
                    this.extractAndConvert(folder, textureCache, clientJar, "block", outputPath);
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                    return;
                }
                clientJar.delete();
                this.delDir(folder);
                logger.info("Done");
                future.complete(null);
            }
            catch (Throwable e) {
                this.delDir(folder);
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    private void extractAndConvert(File folder, TextureCache textureCache, File clientJar, String group, Path outputPath) throws IOException {
        this.extractTextures(clientJar, group, outputPath);
        File[] files = folder.listFiles(f -> f.getName().endsWith(".png"));
        if (files != null) {
            for (File textureFile : files) {
                this.convertFileToTexture(group, textureFile, textureCache);
            }
        }
    }

    private String getMatchingClientUrl() throws IOException {
        JsonObject versionsObj = new JsonParser().parse(this.get(VERSION_MANIFEST_URL)).getAsJsonObject();
        String version = Bukkit.getVersion();
        version = version.substring(version.indexOf("MC: ") + 4, version.lastIndexOf(41));
        String url = null;
        JsonArray versionsArr = versionsObj.get("versions").getAsJsonArray();
        for (JsonElement element : versionsArr) {
            JsonObject obj = element.getAsJsonObject();
            if (!obj.get("id").getAsString().equals(version)) continue;
            url = obj.get("url").getAsString();
        }
        JsonObject latestManifest = new JsonParser().parse(this.get(url)).getAsJsonObject();
        JsonObject downloadsObj = latestManifest.get("downloads").getAsJsonObject();
        JsonObject clientObj = downloadsObj.get("client").getAsJsonObject();
        return clientObj.get("url").getAsString();
    }

    private void extractTextures(File fileToExtract, String group, Path outputPath) throws IOException {
        try (ZipFile zipFile = new ZipFile(fileToExtract, 1);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("assets/minecraft/textures/" + group) || !entry.getName().endsWith(".png")) continue;
                Path entryPath = outputPath.resolve(entry.getName().substring(entry.getName().lastIndexOf(47) + 1));
                if (entry.isDirectory()) {
                    Files.createDirectories(entryPath, new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                InputStream in = zipFile.getInputStream(entry);
                try {
                    Files.copy(in, entryPath, new CopyOption[0]);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
        }
    }

    private void convertFileToTexture(String group, File textureFile, TextureCache textureCache) throws IOException {
        String name = textureFile.getName().substring(0, textureFile.getName().length() - 4);
        BufferedImage textureImg = ImageIO.read(textureFile);
        textureFile.delete();
        Texture texture = new Texture(group, name);
        for (int x = 0; x < 16; ++x) {
            for (int y = 0; y < 16; ++y) {
                if (textureImg.getRGB(x, y) >> 24 == 0) {
                    texture.set(x, y, (byte)0);
                    continue;
                }
                Color color = new Color(textureImg.getRGB(x, y));
                texture.set(x, y, (byte)MapColor.rgbToMapColor(color.getRed(), color.getGreen(), color.getBlue()).getId());
            }
        }
        textureCache.addTexture(group, name, texture);
    }

    private String get(String url) throws IOException {
        int read;
        InputStream in = this.connect(url);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] arr = new byte[256];
        while ((read = in.read(arr)) != -1) {
            out.write(arr, 0, read);
        }
        in.close();
        return out.toString(StandardCharsets.UTF_8);
    }

    private void download(String url, File to) throws IOException {
        to.createNewFile();
        InputStream in = this.connect(url);
        try (FileOutputStream out = new FileOutputStream(to);){
            int read;
            byte[] arr = new byte[256];
            while ((read = in.read(arr)) != -1) {
                out.write(arr, 0, read);
            }
        }
        in.close();
    }

    private InputStream connect(String url) throws IOException {
        InputStream in;
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.setRequestMethod("GET");
        connection.setDoInput(true);
        try {
            in = connection.getInputStream();
        }
        catch (Exception ex) {
            in = connection.getErrorStream();
        }
        return in;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    private void delDir(File dir) {
        if (dir.listFiles() == null || dir.listFiles().length == 0) {
            dir.delete();
        }
    }
}

