/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.visualizer;

import java.util.Comparator;
import java.util.Map;
import org.bukkit.block.BlockFace;

public class DirectionProvider {
    private static final Map<Integer, BlockFace> DIRECTION_MAP = Map.of(0, BlockFace.SOUTH, 360, BlockFace.SOUTH, 90, BlockFace.WEST, 180, BlockFace.NORTH, 270, BlockFace.EAST);

    private DirectionProvider() {
    }

    public static BlockFace getDirection(float yaw) {
        int yawInt = (int)(yaw < 0.0f ? 180.0f + (180.0f - -yaw) : yaw);
        return DIRECTION_MAP.entrySet().stream().map(e -> {
            double diff = (double)Math.max(yawInt, (Integer)e.getKey()) - (double)Math.min(yawInt, (Integer)e.getKey());
            return Map.entry(diff, e);
        }).sorted(Comparator.comparingDouble(Map.Entry::getKey)).map(e -> (BlockFace)((Map.Entry)e.getValue()).getValue()).findFirst().orElseThrow();
    }
}

