/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.visualizer;

import dev.cerus.visualcrafting.api.math.MatrixMath;
import dev.cerus.visualcrafting.api.version.FakeItemDisplay;
import dev.cerus.visualcrafting.api.version.Feature;
import dev.cerus.visualcrafting.api.version.VersionAdapter;
import dev.cerus.visualcrafting.plugin.visualizer.DirectionProvider;
import dev.cerus.visualcrafting.plugin.visualizer.Visualization;
import dev.cerus.visualcrafting.plugin.visualizer.VisualizationController;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Matrix3f;

public class DisplayVisualizationController
implements VisualizationController {
    private final Map<Long, Visualization<DisplayGrid>> visualizationMap = new HashMap<Long, Visualization<DisplayGrid>>();
    private final VersionAdapter versionAdapter;

    public DisplayVisualizationController(VersionAdapter versionAdapter) {
        this.versionAdapter = versionAdapter;
    }

    @Override
    public boolean accepts(VersionAdapter versionAdapter) {
        return versionAdapter.getImplementedFeatures().contains((Object)Feature.ITEM_DISPLAYS);
    }

    @Override
    public void entityClick(Player player, int eid) {
    }

    @Override
    public void recipeSelected(ItemStack[] matrix, ItemStack result, Player actor, Block craftingTable) {
        if (!craftingTable.getRelative(BlockFace.UP).getType().isTransparent()) {
            return;
        }
        long key = this.getBlockKey(craftingTable);
        if (!this.visualizationMap.containsKey(key)) {
            DisplayGrid displayGrid = new DisplayGrid();
            displayGrid.setItems(matrix, result);
            displayGrid.adjustTo(craftingTable.getLocation().clone().add(0.0, 1.0, 0.0), DirectionProvider.getDirection(actor.getLocation().getYaw()).getOppositeFace());
            Visualization<DisplayGrid> visualization = new Visualization<DisplayGrid>(craftingTable, actor, displayGrid);
            this.visualizationMap.put(key, visualization);
            displayGrid.spawnDisplays(this.versionAdapter);
            displayGrid.updateDisplays(this.versionAdapter);
        } else {
            Visualization<DisplayGrid> visualization = this.visualizationMap.get(key);
            if (!visualization.player.getUniqueId().equals(actor.getUniqueId())) {
                return;
            }
            DisplayGrid displayGrid = (DisplayGrid)visualization.obj;
            displayGrid.setItems(matrix, result);
            displayGrid.adjustTo(craftingTable.getLocation().clone().add(0.0, 1.0, 0.0), DirectionProvider.getDirection(actor.getLocation().getYaw()).getOppositeFace());
            displayGrid.updateDisplays(this.versionAdapter);
        }
    }

    @Override
    public void craftingCancelled(Player actor, Block craftingTable) {
        long key = this.getBlockKey(craftingTable);
        if (!this.visualizationMap.containsKey(key)) {
            return;
        }
        Visualization<DisplayGrid> visualization = this.visualizationMap.get(key);
        if (!visualization.player.getUniqueId().equals(actor.getUniqueId())) {
            return;
        }
        this.visualizationMap.remove(key);
        ((DisplayGrid)visualization.obj).destroyDisplays(this.versionAdapter);
    }

    private long getBlockKey(Block block) {
        return this.getBlockKey(block.getX(), block.getY(), block.getZ());
    }

    private long getBlockKey(int x, int y, int z) {
        return (long)x & 0x7FFFFFFL | ((long)z & 0x7FFFFFFL) << 27 | (long)y << 54;
    }

    private static class DisplayGrid {
        private static final double PIXEL_SIZE = 0.0625;
        private static final double FIRST_PIXEL_OFF = 0.3125;
        private static final double PIXEL_OFF = 0.1875;
        private static final ItemStack AIR = new ItemStack(Material.AIR);
        private final FakeItemDisplay[] craftingMatrix = new FakeItemDisplay[27];
        private final FakeItemDisplay craftingResult;
        private final int[] matrixEids = new int[27];
        private int resultEid;

        public DisplayGrid() {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    this.setMatrixCell(col, row, this.createDisplay());
                }
            }
            this.craftingResult = this.createDisplay();
        }

        private FakeItemDisplay createDisplay() {
            return new FakeItemDisplay(null, AIR, MatrixMath.rotationX((float)Math.toRadians(90.0)), MatrixMath.rotationZ(0.0f), MatrixMath.translation(0.0f, 0.0f, 0.0f), FakeItemDisplay.Transform.GUI);
        }

        public void spawnDisplays(VersionAdapter versionAdapter) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    int eid = versionAdapter.spawnItemDisplay(this.getMatrixCell(col, row));
                    this.setMatrixEid(col, row, eid);
                }
            }
            this.setResultEid(versionAdapter.spawnItemDisplay(this.craftingResult));
        }

        public void updateDisplays(VersionAdapter versionAdapter) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    versionAdapter.updateItemDisplay(this.getMatrixEid(col, row), this.getMatrixCell(col, row));
                }
            }
            versionAdapter.updateItemDisplay(this.getResultEid(), this.getCraftingResult());
        }

        public void destroyDisplays(VersionAdapter versionAdapter) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    versionAdapter.destroyEntity(this.getMatrixEid(col, row));
                }
            }
            versionAdapter.destroyEntity(this.getResultEid());
        }

        public void setItems(ItemStack[] matrix, ItemStack result) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    ItemStack item = matrix[row * 3 + col];
                    this.getMatrixCell(col, row).setItemStack(item == null ? AIR : item);
                }
            }
            this.craftingResult.setItemStack(result == null ? AIR : result);
        }

        public void adjustTo(Location loc, BlockFace facing) {
            switch (facing) {
                case NORTH: {
                    this.adjustPos(loc, 0.6875, 0.0, -0.1875, 0.6875, -0.1875, 0.0);
                    break;
                }
                case EAST: {
                    this.adjustPos(loc, 0.3125, 0.1875, 0.0, 0.6875, 0.0, -0.1875);
                    break;
                }
                case SOUTH: {
                    this.adjustPos(loc, 0.3125, 0.0, 0.1875, 0.3125, 0.1875, 0.0);
                    break;
                }
                case WEST: {
                    this.adjustPos(loc, 0.6875, -0.1875, 0.0, 0.3125, 0.0, 0.1875);
                }
            }
            this.adjustRot(facing);
        }

        private void adjustPos(Location baseLoc, double startX, double addXRow, double addXCol, double startZ, double addZRow, double addZCol) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    FakeItemDisplay item = this.getMatrixCell(col, row);
                    double x = startX + (double)row * addXRow + (double)col * addXCol;
                    double z = startZ + (double)row * addZRow + (double)col * addZCol;
                    item.setLocation(baseLoc);
                    item.setTranslation(MatrixMath.translation((float)x, 0.005f, (float)z));
                }
            }
            double x = startX + addXCol + this.ceil(addXRow) * -0.21;
            double z = startZ + addZCol + this.ceil(addZRow) * -0.21;
            this.craftingResult.setLocation(baseLoc);
            this.craftingResult.setTranslation(MatrixMath.translation((float)x, 0.005f, (float)z));
        }

        private void adjustRot(BlockFace facing) {
            for (int row = 0; row < 3; ++row) {
                for (int col = 0; col < 3; ++col) {
                    FakeItemDisplay item = this.getMatrixCell(col, row);
                    item.setRotationZ(this.rotationZ(facing));
                }
            }
            this.craftingResult.setRotationZ(this.rotationZ(facing));
        }

        private Matrix3f rotationZ(BlockFace face) {
            return switch (face) {
                case BlockFace.NORTH -> MatrixMath.rotationZ((float)Math.toRadians(0.0));
                case BlockFace.EAST -> MatrixMath.rotationZ((float)Math.toRadians(90.0));
                case BlockFace.SOUTH -> MatrixMath.rotationZ((float)Math.toRadians(180.0));
                case BlockFace.WEST -> MatrixMath.rotationZ((float)Math.toRadians(270.0));
                default -> throw new UnsupportedOperationException();
            };
        }

        private double ceil(double f) {
            return f < 0.0 ? -this.ceil(-f) : Math.ceil(f);
        }

        public void setMatrixCell(int col, int row, FakeItemDisplay display) {
            this.craftingMatrix[row * 3 + col] = display;
        }

        public FakeItemDisplay getMatrixCell(int col, int row) {
            return this.craftingMatrix[row * 3 + col];
        }

        public FakeItemDisplay getCraftingResult() {
            return this.craftingResult;
        }

        public void setMatrixEid(int col, int row, int eid) {
            this.matrixEids[row * 3 + col] = eid;
        }

        public int getMatrixEid(int col, int row) {
            return this.matrixEids[row * 3 + col];
        }

        public int getResultEid() {
            return this.resultEid;
        }

        public void setResultEid(int resultEid) {
            this.resultEid = resultEid;
        }
    }
}

