/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.visualizer;

import dev.cerus.visualcrafting.api.version.FakeMap;
import dev.cerus.visualcrafting.api.version.Feature;
import dev.cerus.visualcrafting.api.version.VersionAdapter;
import dev.cerus.visualcrafting.plugin.texture.Texture;
import dev.cerus.visualcrafting.plugin.texture.TextureCache;
import dev.cerus.visualcrafting.plugin.visualizer.DirectionProvider;
import dev.cerus.visualcrafting.plugin.visualizer.Visualization;
import dev.cerus.visualcrafting.plugin.visualizer.VisualizationController;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class MapVisualizationController
implements VisualizationController {
    private static final int MIN_X = 32;
    private static final int MIN_Y = 32;
    private static final int SPACE = 8;
    private static final int WIDTH = 16;
    private static final int HEIGHT = 16;
    private final Map<Long, Visualization<FramedMap>> visualizationMap = new HashMap<Long, Visualization<FramedMap>>();
    private final VersionAdapter versionAdapter;
    private final TextureCache textureCache;

    public MapVisualizationController(VersionAdapter versionAdapter, TextureCache textureCache) {
        this.versionAdapter = versionAdapter;
        this.textureCache = textureCache;
    }

    @Override
    public boolean accepts(VersionAdapter versionAdapter) {
        return versionAdapter.getImplementedFeatures().contains((Object)Feature.MAPS);
    }

    @Override
    public void entityClick(Player player, int eid) {
        this.visualizationMap.values().stream().filter(visualization -> ((FramedMap)visualization.obj).frameEntityId == eid).findAny().ifPresent(visualization -> {
            PlayerInteractEvent interactEvent = new PlayerInteractEvent(player, Action.RIGHT_CLICK_BLOCK, player.getInventory().getItemInMainHand(), visualization.block.getLocation().getBlock(), BlockFace.SELF, EquipmentSlot.HAND);
            Bukkit.getPluginManager().callEvent((Event)interactEvent);
            if (interactEvent.useInteractedBlock() == Event.Result.ALLOW || interactEvent.useInteractedBlock() == Event.Result.DEFAULT) {
                player.openWorkbench(visualization.block.getLocation(), false);
            }
        });
    }

    @Override
    public void recipeSelected(ItemStack[] matrix, ItemStack result, Player actor, Block craftingTable) {
        if (!craftingTable.getRelative(BlockFace.UP).getType().isTransparent()) {
            return;
        }
        long key = this.getBlockKey(craftingTable);
        if (!this.visualizationMap.containsKey(key)) {
            int eid = this.versionAdapter.spawnItemFrame(craftingTable.getLocation().clone().add(0.0, 1.0, 0.0), BlockFace.UP);
            FakeMap map = this.versionAdapter.createMap();
            Visualization<FramedMap> visualization = new Visualization<FramedMap>(craftingTable, actor, new FramedMap(map, eid));
            this.visualizationMap.put(key, visualization);
            this.updateMap(map, matrix, result);
            this.versionAdapter.sendMap(map);
            this.versionAdapter.updateItemFrame(eid, map.toItem(), this.calculateFrameRotation(actor), true);
        } else {
            Visualization<FramedMap> visualization = this.visualizationMap.get(key);
            if (!visualization.player.getUniqueId().equals(actor.getUniqueId())) {
                return;
            }
            this.updateMap(((FramedMap)visualization.obj).map, matrix, result);
            this.versionAdapter.sendMap(((FramedMap)visualization.obj).map);
            this.versionAdapter.updateItemFrame(((FramedMap)visualization.obj).frameEntityId, ((FramedMap)visualization.obj).map.toItem(), this.calculateFrameRotation(actor), true);
        }
    }

    @Override
    public void craftingCancelled(Player actor, Block craftingTable) {
        long key = this.getBlockKey(craftingTable);
        if (!this.visualizationMap.containsKey(key)) {
            return;
        }
        Visualization<FramedMap> visualization = this.visualizationMap.get(key);
        if (!visualization.player.getUniqueId().equals(actor.getUniqueId())) {
            return;
        }
        this.visualizationMap.remove(key);
        this.versionAdapter.destroyEntity(((FramedMap)visualization.obj).frameEntityId);
    }

    private void updateMap(FakeMap map, ItemStack[] matrix, ItemStack result) {
        for (int x = 0; x < 128; ++x) {
            for (int y = 0; y < 128; ++y) {
                map.setPixel(x, y, (byte)0);
            }
        }
        if (result != null) {
            this.drawItem(map, result.getType(), 56, 8);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                ItemStack item = matrix[row * 3 + col];
                int x = 32 + col * 24;
                int y = 32 + row * 24;
                if (item == null) continue;
                this.drawItem(map, item.getType(), x, y);
            }
        }
    }

    private void drawItem(FakeMap map, Material material, int baseX, int baseY) {
        Texture texture;
        if (material.isBlock()) {
            texture = this.textureCache.getTexture("block", material.name().toLowerCase());
            if (texture == null) {
                texture = this.textureCache.getTexture("item", material.name().toLowerCase());
            }
        } else if (material.isItem()) {
            texture = this.textureCache.getTexture("item", material.name().toLowerCase());
            if (texture == null) {
                texture = this.textureCache.getTexture("block", material.name().toLowerCase());
            }
        } else {
            texture = null;
        }
        if (texture != null) {
            for (int xx = 0; xx < 16; ++xx) {
                for (int yy = 0; yy < 16; ++yy) {
                    map.setPixel(baseX + xx, baseY + yy, texture.get(xx, yy));
                }
            }
        }
    }

    private Rotation calculateFrameRotation(Player actor) {
        float yaw = actor.getLocation().getYaw();
        return switch (DirectionProvider.getDirection(yaw).getOppositeFace()) {
            case BlockFace.WEST -> Rotation.CLOCKWISE_45;
            case BlockFace.NORTH -> Rotation.CLOCKWISE;
            case BlockFace.EAST -> Rotation.CLOCKWISE_135;
            default -> Rotation.NONE;
        };
    }

    private long getBlockKey(Block block) {
        return this.getBlockKey(block.getX(), block.getY(), block.getZ());
    }

    private long getBlockKey(int x, int y, int z) {
        return (long)x & 0x7FFFFFFL | ((long)z & 0x7FFFFFFL) << 27 | (long)y << 54;
    }

    private static class FramedMap {
        public FakeMap map;
        public int frameEntityId;

        public FramedMap(FakeMap map, int frameEntityId) {
            this.map = map;
            this.frameEntityId = frameEntityId;
        }
    }
}

