/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.v16r3;

import dev.cerus.visualcrafting.api.config.Config;
import dev.cerus.visualcrafting.api.version.FakeMap;
import dev.cerus.visualcrafting.api.version.VersionAdapter;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.server.v1_16_R3.DataWatcher;
import net.minecraft.server.v1_16_R3.DataWatcherRegistry;
import net.minecraft.server.v1_16_R3.EntityTypes;
import net.minecraft.server.v1_16_R3.Packet;
import net.minecraft.server.v1_16_R3.PacketPlayInUseEntity;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_16_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_16_R3.PacketPlayOutMap;
import net.minecraft.server.v1_16_R3.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_16_R3.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class VersionAdapter16R3
extends VersionAdapter {
    private Config config;
    private BiConsumer<Player, Integer> entityClickCallback;
    private int nextEntityId;
    private int nextMapId;

    @Override
    public void init(Config config, BiConsumer<Player, Integer> entityClickCallback) {
        this.config = config;
        this.entityClickCallback = entityClickCallback;
        this.nextEntityId = config.entityIdRangeMin();
        this.nextMapId = config.mapIdRangeMin();
    }

    @Override
    public void inject(final Player player) {
        if (this.config.enablePacketListening()) {
            ((CraftPlayer)player).getHandle().playerConnection.networkManager.channel.pipeline().addBefore("packet_handler", "visual_crafting", (ChannelHandler)new ChannelDuplexHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof PacketPlayInUseEntity) {
                        PacketPlayInUseEntity useEntity = (PacketPlayInUseEntity)msg;
                        VersionAdapter16R3.this.handlePacketIn(player, useEntity);
                    }
                    super.channelRead(ctx, msg);
                }
            });
        }
    }

    private void handlePacketIn(Player player, PacketPlayInUseEntity packet) {
        try {
            Field a = packet.getClass().getDeclaredField("a");
            a.setAccessible(true);
            this.entityClickCallback.accept(player, (Integer)a.get(packet));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int spawnItemFrame(Location location, BlockFace direction) {
        int n;
        int eid = this.getNewEntityId();
        UUID uUID = UUID.randomUUID();
        double d = location.getBlockX();
        double d2 = location.getBlockY();
        double d3 = location.getBlockZ();
        float f = direction == BlockFace.DOWN ? 90.0f : (direction == BlockFace.UP ? -90.0f : 0.0f);
        float f2 = switch (direction) {
            case BlockFace.NORTH -> -180.0f;
            case BlockFace.EAST -> -90.0f;
            case BlockFace.WEST -> 90.0f;
            default -> 0.0f;
        };
        if (this.config.adjustHitbox()) {
            n = 0;
        } else {
            switch (direction) {
                case UP: {
                    n = 1;
                    break;
                }
                case NORTH: {
                    n = 2;
                    break;
                }
                case SOUTH: {
                    n = 3;
                    break;
                }
                case WEST: {
                    n = 4;
                    break;
                }
                case EAST: {
                    n = 5;
                    break;
                }
                default: {
                    n = 0;
                }
            }
        }
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity(eid, uUID, d, d2, d3, f, f2, EntityTypes.ITEM_FRAME, n, new Vec3D(0.0, 0.0, 0.0));
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
        return eid;
    }

    @Override
    public void updateItemFrame(int frameId, ItemStack itemStack, Rotation rotation, boolean invisible) {
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata();
        this.setField(packet, "a", frameId);
        this.setField(packet, "b", Arrays.asList(new DataWatcher.Item(DataWatcherRegistry.g.a(7), (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)), new DataWatcher.Item(DataWatcherRegistry.b.a(8), (Object)rotation.ordinal()), new DataWatcher.Item(DataWatcherRegistry.a.a(0), (Object)((byte)(invisible ? 32 : 0)))));
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    @Override
    public void destroyEntity(int entityId) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{entityId});
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    @Override
    public FakeMap createMap() {
        return this.createMap(this.getNewMapId());
    }

    @Override
    public void sendMap(FakeMap map) {
        PacketPlayOutMap packet = new PacketPlayOutMap(map.getId(), 0, false, false, Set.of(), this.getMapData(map), 0, 0, 128, 128);
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket(packet);
    }

    private int getNewEntityId() {
        if (this.nextEntityId >= this.config.entityIdRangeMax()) {
            this.nextEntityId = this.config.entityIdRangeMin();
            return this.nextEntityId;
        }
        return this.nextEntityId++;
    }

    private int getNewMapId() {
        if (this.nextMapId >= this.config.mapIdRangeMax()) {
            this.nextMapId = this.config.mapIdRangeMin();
            return this.nextMapId;
        }
        return this.nextMapId++;
    }

    private void setField(Object o, String field, Object value) {
        try {
            Field declaredField = o.getClass().getDeclaredField(field);
            declaredField.setAccessible(true);
            declaredField.set(o, value);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }
}

