/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.api.version;

import dev.cerus.visualcrafting.api.config.Config;
import dev.cerus.visualcrafting.api.version.FakeItemDisplay;
import dev.cerus.visualcrafting.api.version.FakeMap;
import dev.cerus.visualcrafting.api.version.Feature;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class VersionAdapter {
    protected static final EnumSet<Feature> FEATURES_BASE = EnumSet.of(Feature.MAPS);
    protected static final EnumSet<Feature> FEATURES_DISPLAY = EnumSet.of(Feature.MAPS, Feature.ITEM_DISPLAYS);

    public abstract void init(Config var1, BiConsumer<Player, Integer> var2);

    public abstract void inject(Player var1);

    public abstract int spawnItemFrame(Location var1, BlockFace var2);

    public abstract void updateItemFrame(int var1, ItemStack var2, Rotation var3, boolean var4);

    public int spawnItemDisplay(FakeItemDisplay itemDisplay) {
        throw new UnsupportedOperationException();
    }

    public void updateItemDisplay(int displayId, FakeItemDisplay itemDisplay) {
        throw new UnsupportedOperationException();
    }

    public abstract void destroyEntity(int var1);

    protected FakeMap createMap(int id, Object handle) {
        return new FakeMap(id, handle);
    }

    protected FakeMap createMap(int id) {
        return this.createMap(id, null);
    }

    protected byte[] getMapData(FakeMap fakeMap) {
        return fakeMap.getData();
    }

    protected Object getMapHandle(FakeMap fakeMap) {
        return fakeMap.getHandle();
    }

    public abstract FakeMap createMap();

    public abstract void sendMap(FakeMap var1);

    public EnumSet<Feature> getImplementedFeatures() {
        return FEATURES_BASE;
    }
}

