/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.listener;

import dev.cerus.visualcrafting.plugin.visualizer.VisualizationController;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;

public class CancelCraftingListener
implements Listener {
    private final VisualizationController visualizationController;

    public CancelCraftingListener(VisualizationController visualizationController) {
        this.visualizationController = visualizationController;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        Inventory inventory = event.getView().getTopInventory();
        if (!(inventory instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)inventory;
        if (inv.getSize() != 10) {
            return;
        }
        if (inv.getLocation() == null) {
            return;
        }
        this.visualizationController.craftingCancelled((Player)event.getView().getPlayer(), inv.getLocation().getBlock());
    }
}

