/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.plugin.listener;

import dev.cerus.visualcrafting.folia.FoliaUtil;
import dev.cerus.visualcrafting.plugin.VisualCraftingPlugin;
import dev.cerus.visualcrafting.plugin.visualizer.VisualizationController;
import java.util.Arrays;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CraftingInventoryInteractListener
implements Listener {
    private final VisualCraftingPlugin plugin;
    private final VisualizationController visualizationController;

    public CraftingInventoryInteractListener(VisualCraftingPlugin plugin, VisualizationController visualizationController) {
        this.plugin = plugin;
        this.visualizationController = visualizationController;
    }

    @EventHandler
    public void onDrag(InventoryDragEvent event) {
        this.onInteract(event.getView());
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        this.onInteract(event.getView());
    }

    @EventHandler
    public void onPrepareCraft(PrepareItemCraftEvent event) {
        this.onInteract(event.getView());
    }

    public void onInteract(InventoryView view) {
        Inventory inventory = view.getTopInventory();
        if (!(inventory instanceof CraftingInventory)) {
            return;
        }
        CraftingInventory inv = (CraftingInventory)inventory;
        ItemStack[] matrix = inv.getMatrix();
        if (matrix.length != 9) {
            return;
        }
        Player player = (Player)view.getPlayer();
        Runnable cmd = () -> {
            if (!player.isOnline()) {
                return;
            }
            if (Arrays.stream(matrix).allMatch(Objects::isNull) && inv.getResult() == null) {
                this.visualizationController.craftingCancelled(player, inv.getLocation().getBlock());
            } else {
                this.visualizationController.recipeSelected(matrix, inv.getResult(), player, inv.getLocation().getBlock());
            }
        };
        FoliaUtil.runIfFolia(() -> FoliaUtil.scheduleOnEntity(this.plugin, (Entity)player, cmd, 1), () -> Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.plugin, cmd, 1L));
    }
}

