/*
 * Decompiled with CFR 0.152.
 */
package dev.cerus.visualcrafting.v21r5;

import com.mojang.math.Transformation;
import dev.cerus.visualcrafting.api.config.Config;
import dev.cerus.visualcrafting.api.version.FakeItemDisplay;
import dev.cerus.visualcrafting.api.version.FakeMap;
import dev.cerus.visualcrafting.api.version.Feature;
import dev.cerus.visualcrafting.api.version.VersionAdapter;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata;
import net.minecraft.network.protocol.game.PacketPlayOutMap;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.network.PlayerConnection;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.WorldMap;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.joml.Matrix4fc;

public class VersionAdapter21R5
extends VersionAdapter {
    private Config config;
    private BiConsumer<Player, Integer> entityClickCallback;
    private int nextEntityId;
    private int nextMapId;
    private Field netManField;

    private NetworkManager getNetworkManager(PlayerConnection b2) {
        try {
            if (this.netManField == null) {
                this.netManField = ServerCommonPacketListenerImpl.class.getDeclaredField("e");
                this.netManField.setAccessible(true);
            }
            return (NetworkManager)this.netManField.get(b2);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void init(Config config, BiConsumer<Player, Integer> entityClickCallback) {
        this.config = config;
        this.entityClickCallback = entityClickCallback;
        this.nextEntityId = config.entityIdRangeMin();
        this.nextMapId = config.mapIdRangeMin();
    }

    @Override
    public void inject(final Player player) {
        if (this.config.enablePacketListening()) {
            NetworkManager netMan = this.getNetworkManager(((CraftPlayer)player).getHandle().g);
            netMan.n.pipeline().addBefore("packet_handler", "visual_crafting", (ChannelHandler)new ChannelDuplexHandler(){

                public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                    if (msg instanceof PacketPlayInUseEntity) {
                        PacketPlayInUseEntity useEntity = (PacketPlayInUseEntity)msg;
                        VersionAdapter21R5.this.handlePacketIn(player, useEntity);
                    }
                    super.channelRead(ctx, msg);
                }
            });
        }
    }

    private void handlePacketIn(Player player, PacketPlayInUseEntity packet) {
        try {
            Field a = packet.getClass().getDeclaredField("b");
            a.setAccessible(true);
            this.entityClickCallback.accept(player, (Integer)a.get(packet));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int spawnItemFrame(Location location, BlockFace direction) {
        int eid = this.getNewEntityId();
        UUID uUID = UUID.randomUUID();
        double d = location.getBlockX();
        double d2 = location.getBlockY();
        double d3 = location.getBlockZ();
        float f = direction == BlockFace.DOWN ? 90.0f : (direction == BlockFace.UP ? -90.0f : 0.0f);
        float f2 = switch (direction) {
            case BlockFace.NORTH -> -180.0f;
            case BlockFace.EAST -> -90.0f;
            case BlockFace.WEST -> 90.0f;
            default -> 0.0f;
        };
        int n = switch (direction) {
            case BlockFace.UP -> 1;
            case BlockFace.NORTH -> 2;
            case BlockFace.SOUTH -> 3;
            case BlockFace.WEST -> 4;
            case BlockFace.EAST -> 5;
            default -> 0;
        };
        Vec3D vec3D = new Vec3D(0.0, 0.0, 0.0);
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity(eid, uUID, d, d2, d3, f, f2, EntityTypes.au, n, vec3D, switch (direction) {
            case BlockFace.NORTH -> -180.0;
            case BlockFace.EAST -> -90.0;
            case BlockFace.WEST -> 90.0;
            default -> 0.0;
        });
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
        return eid;
    }

    @Override
    public int spawnItemDisplay(FakeItemDisplay itemDisplay) {
        int eid = this.getNewEntityId();
        PacketPlayOutSpawnEntity packet = new PacketPlayOutSpawnEntity(eid, UUID.randomUUID(), (double)itemDisplay.getLocation().getBlockX(), (double)itemDisplay.getLocation().getBlockY(), (double)itemDisplay.getLocation().getBlockZ(), 0.0f, 0.0f, EntityTypes.at, 0, new Vec3D(0.0, 0.0, 0.0), 0.0);
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
        return eid;
    }

    @Override
    public void updateItemFrame(int frameId, ItemStack itemStack, Rotation rotation, boolean invisible) {
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(frameId, Arrays.asList(new DataWatcher.c(9, DataWatcherRegistry.h, (Object)CraftItemStack.asNMSCopy((ItemStack)itemStack)), new DataWatcher.c(10, DataWatcherRegistry.b, (Object)rotation.ordinal()), new DataWatcher.c(0, DataWatcherRegistry.a, (Object)((byte)(invisible ? 32 : 0)))));
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    @Override
    public void updateItemDisplay(int displayId, FakeItemDisplay itemDisplay) {
        Transformation nmsTransf = new Transformation((Matrix4fc)itemDisplay.getTransformationMatrix());
        PacketPlayOutEntityMetadata packet = new PacketPlayOutEntityMetadata(displayId, Arrays.asList(new DataWatcher.c(11, DataWatcherRegistry.H, (Object)nmsTransf.e()), new DataWatcher.c(12, DataWatcherRegistry.H, (Object)nmsTransf.g()), new DataWatcher.c(13, DataWatcherRegistry.I, (Object)nmsTransf.f()), new DataWatcher.c(14, DataWatcherRegistry.I, (Object)nmsTransf.h()), new DataWatcher.c(23, DataWatcherRegistry.h, (Object)CraftItemStack.asNMSCopy((ItemStack)itemDisplay.getItemStack())), new DataWatcher.c(24, DataWatcherRegistry.a, (Object)((byte)itemDisplay.getTransform().ordinal()))));
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    @Override
    public void destroyEntity(int entityId) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{entityId});
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    @Override
    public FakeMap createMap() {
        int mapId = this.getNewMapId();
        return this.createMap(mapId, new MapId(mapId));
    }

    @Override
    public void sendMap(FakeMap map) {
        PacketPlayOutMap packet = new PacketPlayOutMap((MapId)this.getMapHandle(map), 0, true, Collections.emptyList(), new WorldMap.c(0, 0, 128, 128, this.getMapData(map)));
        Bukkit.getOnlinePlayers().forEach(player -> this.sendPacket((Player)player, (Packet<?>)packet));
    }

    @Override
    public EnumSet<Feature> getImplementedFeatures() {
        return FEATURES_DISPLAY;
    }

    private void sendPacket(Player player, Packet<?> packet) {
        ((CraftPlayer)player).getHandle().g.b(packet);
    }

    private int getNewEntityId() {
        if (this.nextEntityId >= this.config.entityIdRangeMax()) {
            this.nextEntityId = this.config.entityIdRangeMin();
            return this.nextEntityId;
        }
        return this.nextEntityId++;
    }

    private int getNewMapId() {
        if (this.nextMapId >= this.config.mapIdRangeMax()) {
            this.nextMapId = this.config.mapIdRangeMin();
            return this.nextMapId;
        }
        return this.nextMapId++;
    }
}

