/*
 * Decompiled with CFR 0.152.
 */
package net.capozi.maisonnette.common.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.capozi.maisonnette.Maisonnette;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5847;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7151;

public final class ExpandedJigsawStructure
extends class_3195 {
    public static final int MAX_SIZE = 12800;
    public static final Codec<ExpandedJigsawStructure> CODEC = class_5699.method_51699((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExpandedJigsawStructure.method_42697((RecordCodecBuilder.Instance)instance), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(s -> s.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(s -> s.startJigsawName), (App)Codec.intRange((int)0, (int)1000).fieldOf("size").forGetter(s -> s.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(s -> s.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(s -> s.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(s -> s.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)12800).fieldOf("max_distance_from_center").forGetter(s -> s.maxDistanceFromCenter)).apply((Applicative)instance, ExpandedJigsawStructure::new)), ExpandedJigsawStructure::validate).codec();
    private final class_6880<class_3785> startPool;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static DataResult<ExpandedJigsawStructure> validate(ExpandedJigsawStructure structure) {
        int terrainOffset = switch (structure.method_42701()) {
            default -> throw new IncompatibleClassChangeError();
            case class_5847.field_28922 -> 0;
            case class_5847.field_28923, class_5847.field_38431, class_5847.field_38432 -> 12;
        };
        return structure.maxDistanceFromCenter + terrainOffset > 12800 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 12800") : DataResult.success((Object)((Object)structure));
    }

    public ExpandedJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public ExpandedJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, class_6122 startHeight, boolean useExpansionHack, class_2902.class_2903 projectStartToHeightmap) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 80);
    }

    public ExpandedJigsawStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, int size, class_6122 startHeight, boolean useExpansionHack) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.empty(), 80);
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        int i = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), i, chunkPos.method_8328());
        return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public class_7151<?> method_41618() {
        return Maisonnette.EXPANDED_JIGSAW;
    }
}

