/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.util;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.util.PlayerInventoryUtils;
import java.util.Objects;
import net.minecraft.class_1292;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2868;
import net.minecraft.class_310;
import net.minecraft.class_3486;
import net.minecraft.class_636;
import net.minecraft.class_746;

public class InventoryManagerUtils {
    public static void autoSwitch(class_2248 block) {
        InventoryManagerUtils.autoSwitch(block.method_9564());
    }

    public static void autoSwitch(class_2680 blockState) {
        float lastTime = -1.0f;
        int lastSlot = -1;
        for (int i = 0; i < BedrockMiner.playerInventory.method_5439(); ++i) {
            float blockBreakingTotalTime;
            class_1799 itemStack = BedrockMiner.playerInventory.method_5438(i);
            if (InventoryManagerUtils.isItemDamageWarning(itemStack, 5) || (blockBreakingTotalTime = InventoryManagerUtils.getBlockBreakingTotalTime(blockState, itemStack)) == -1.0f || lastTime != -1.0f && !(lastTime > blockBreakingTotalTime)) continue;
            lastTime = blockBreakingTotalTime;
            lastSlot = i;
        }
        if (lastSlot != -1) {
            InventoryManagerUtils.switchToSlot(lastSlot);
        }
    }

    public static void swapSlots(class_746 player, class_636 interactionManager, int sourceSlot, int hotbarIndex) {
        if (player == null || interactionManager == null) {
            return;
        }
        if (player.field_7512 == player.field_7498) {
            if (sourceSlot == hotbarIndex) {
                return;
            }
            interactionManager.method_2906(player.field_7512.field_7763, sourceSlot, hotbarIndex, class_1713.field_7791, (class_1657)player);
        }
    }

    public static void pickFromInventory(class_746 player, class_636 interactionManager, int slot) {
        if (player == null || interactionManager == null) {
            return;
        }
        class_1661 playerInventory = player.method_31548();
        if (player.field_7512 != player.field_7498) {
            return;
        }
        if (class_1661.method_7380((int)slot)) {
            PlayerInventoryUtils.setSelectedSlot(slot);
            return;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 itemStack = playerInventory.method_5438(i);
            if (!itemStack.method_7960()) continue;
            InventoryManagerUtils.swapSlots(player, interactionManager, slot, i);
            PlayerInventoryUtils.setSelectedSlot(i);
            return;
        }
        InventoryManagerUtils.swapSlots(player, interactionManager, slot, 0);
        PlayerInventoryUtils.setSelectedSlot(0);
    }

    public static void switchToSlot(int slot) {
        if (class_1661.method_7380((int)slot)) {
            PlayerInventoryUtils.setSelectedSlot(slot);
        } else {
            InventoryManagerUtils.pickFromInventory(BedrockMiner.player, BedrockMiner.interactionManager, slot);
        }
        BedrockMiner.networkHandler.method_52787((class_2596)new class_2868(PlayerInventoryUtils.getSelectedSlot()));
    }

    public static void switchToItem(int minDamage, class_1792 ... items) {
        class_2371<class_1799> MainStacks = PlayerInventoryUtils.getMainStacks(BedrockMiner.playerInventory);
        for (int i = 0; i < MainStacks.size(); ++i) {
            class_1799 stack = (class_1799)MainStacks.get(i);
            if (stack.method_7960()) continue;
            for (class_1792 item : items) {
                if (!stack.method_31574(item) || minDamage > 0 && InventoryManagerUtils.isItemDamageWarning(stack, minDamage)) continue;
                InventoryManagerUtils.switchToSlot(i);
                return;
            }
        }
    }

    public static void switchToItem(class_1792 ... items) {
        InventoryManagerUtils.switchToItem(-1, items);
    }

    public static boolean isItemDamageWarning(class_1799 itemStack, int minDamage) {
        int damageMax = itemStack.method_7936();
        if (damageMax > 0) {
            int damage = itemStack.method_7919();
            int damageSurplus = damageMax - damage;
            return damageSurplus <= minDamage;
        }
        return false;
    }

    public static boolean canInstantlyMinePiston() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return false;
        }
        class_1661 playerInventory = player.method_31548();
        for (int i = 0; i < playerInventory.method_5439(); ++i) {
            if (!InventoryManagerUtils.isInstantBreakingBlock(class_2246.field_10560.method_9564(), playerInventory.method_5438(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstantBreakingBlock(class_2680 blockState, class_1799 itemStack) {
        float hardness = blockState.method_26204().method_36555();
        if (hardness < 0.0f) {
            return false;
        }
        float speed = InventoryManagerUtils.getBlockBreakingSpeed(blockState, itemStack);
        return speed > hardness * 30.0f;
    }

    public static float getBlockBreakingTotalTime(class_2680 blockState, class_1799 itemStack) {
        float hardness = blockState.method_26204().method_36555();
        if (hardness < 0.0f) {
            return -1.0f;
        }
        float speed = InventoryManagerUtils.getBlockBreakingSpeed(blockState, itemStack);
        return (float)((double)hardness * 1.5 / (double)speed);
    }

    private static float getBlockBreakingSpeed(class_2680 blockState, class_1799 itemStack) {
        int level;
        float f = itemStack.method_7924(blockState);
        if (f > 1.0f && (level = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)itemStack)) > 0 && !itemStack.method_7960()) {
            f += (float)(level * level + 1);
        }
        if (class_1292.method_5576((class_1309)BedrockMiner.player)) {
            f *= 1.0f + (float)(class_1292.method_5575((class_1309)BedrockMiner.player) + 1) * 0.2f;
        }
        if (BedrockMiner.player.method_6059(class_1294.field_5901)) {
            float g = switch (Objects.requireNonNull(BedrockMiner.player.method_6112(class_1294.field_5901)).method_5578()) {
                case 0 -> 0.3f;
                case 1 -> 0.09f;
                case 2 -> 0.0027f;
                default -> 8.1E-4f;
            };
            f *= g;
        }
        if (BedrockMiner.player.method_5777(class_3486.field_15517) && !class_1890.method_8200((class_1309)BedrockMiner.player)) {
            f /= 5.0f;
        }
        if (!BedrockMiner.player.method_24828()) {
            f /= 5.0f;
        }
        if (!BedrockMiner.player.method_24828()) {
            f /= 5.0f;
        }
        return f;
    }

    public static int getInventoryItemCount(class_1792 item) {
        return BedrockMiner.playerInventory.method_18861(item);
    }
}

