/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.task;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.api.ITaskManager;
import com.github.bunnyi116.bedrockminer.config.ConfigManager;
import com.github.bunnyi116.bedrockminer.task.Task;
import com.github.bunnyi116.bedrockminer.task.TaskRegion;
import com.github.bunnyi116.bedrockminer.util.BlockUtils;
import com.github.bunnyi116.bedrockminer.util.CombinedIterator;
import com.github.bunnyi116.bedrockminer.util.InventoryManagerUtils;
import com.github.bunnyi116.bedrockminer.util.MessageUtils;
import com.github.bunnyi116.bedrockminer.util.PlayerLookManager;
import com.github.bunnyi116.bedrockminer.util.PlayerUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3341;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;

public class TaskManager
implements ITaskManager {
    @Nullable
    private static volatile TaskManager INSTANCE;
    private final ArrayList<Task> pendingBlockTasks = new ArrayList();
    private final List<TaskRegion> pendingRegionTasks = new ArrayList<TaskRegion>();
    @Nullable
    private Task currentTask;
    private boolean working;
    private boolean processing;
    private int resetCount;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void tick() {
        boolean setOverlayMessage;
        if (!BedrockMiner.gameVariableIsValid()) {
            return;
        }
        if (ConfigManager.getInstance().getConfig().disable || !this.isWorking()) {
            PlayerLookManager.INSTANCE.tick();
            return;
        }
        if (this.pendingBlockTasks.isEmpty() && this.pendingRegionTasks.isEmpty() && ConfigManager.getInstance().getConfig().ranges.isEmpty()) {
            this.currentTask = null;
            return;
        }
        boolean bl = setOverlayMessage = this.currentTask != null;
        if (!this.isAllowExecutionEnvironment(setOverlayMessage)) return;
        if (this.currentTask != null) {
            if (this.currentTask.world == BedrockMiner.world && this.currentTask.canInteractWithBlockAt()) {
                this.processing = true;
                this.currentTask.tick();
                this.resetCount = 0;
                this.processing = false;
                if (!this.currentTask.isComplete()) return;
                this.pendingBlockTasks.remove(this.currentTask);
                this.currentTask = null;
            } else if (this.pendingBlockTasks.size() > 1 || !ConfigManager.getInstance().getConfig().ranges.isEmpty()) {
                this.currentTask = null;
                this.resetCount = 0;
            } else if (this.resetCount++ >= 40) {
                this.currentTask = null;
                this.resetCount = 0;
            }
        }
        if (this.currentTask == null) {
            Iterator<Task> iterator1 = this.pendingBlockTasks.iterator();
            while (iterator1.hasNext()) {
                Task task = iterator1.next();
                if (!task.canInteractWithBlockAt() || PlayerLookManager.INSTANCE.isModify() && PlayerLookManager.INSTANCE.getTask() != task) continue;
                if (task.world != BedrockMiner.world) {
                    iterator1.remove();
                    continue;
                }
                this.currentTask = task;
                return;
            }
        }
        if (this.currentTask != null) return;
        CombinedIterator<TaskRegion> iterator2 = new CombinedIterator<TaskRegion>(ConfigManager.getInstance().getConfig().ranges, this.pendingRegionTasks);
        while (iterator2.hasNext()) {
            int blockInteractionRange;
            class_3341 playerBox;
            class_3341 playerExpandBox;
            class_3341 rangeBox;
            TaskRegion range = iterator2.next();
            if (!range.isForWorld(BedrockMiner.world) || !(rangeBox = class_3341.method_34390((class_2382)range.pos1, (class_2382)range.pos2)).method_14657(playerExpandBox = (playerBox = new class_3341(BedrockMiner.player.method_24515())).method_35410((int)PlayerUtils.getBlockInteractionRange()))) continue;
            for (int y = blockInteractionRange = (int)PlayerUtils.getBlockInteractionRange() - 1; y > -blockInteractionRange; --y) {
                for (int x = -blockInteractionRange; x <= blockInteractionRange; ++x) {
                    for (int z = -blockInteractionRange; z <= blockInteractionRange; ++z) {
                        Task task;
                        class_2338 blockPos = BedrockMiner.player.method_24515().method_10069(x, y, z);
                        class_3341 box = new class_3341(blockPos);
                        if (!rangeBox.method_14657(box)) continue;
                        class_2680 blockState = BedrockMiner.world.method_8320(blockPos);
                        class_2248 block = blockState.method_26204();
                        if (blockState.method_26215() || BlockUtils.isReplaceable(blockState) || !ConfigManager.getInstance().getConfig().isAllowBlock(block) || ConfigManager.getInstance().getConfig().isFloorsBlacklist(blockPos) || !(task = new Task(BedrockMiner.world, block, blockPos)).canInteractWithBlockAt() || PlayerLookManager.INSTANCE.isModify() && PlayerLookManager.INSTANCE.getTask() != task) continue;
                        if (task.world != BedrockMiner.world) {
                            iterator2.remove();
                            continue;
                        }
                        this.currentTask = task;
                        return;
                    }
                }
            }
        }
    }

    public void clearTask() {
        this.pendingBlockTasks.clear();
        if (PlayerLookManager.INSTANCE.isModify()) {
            PlayerLookManager.INSTANCE.reset();
        }
        MessageUtils.addMessage(I18n.COMMAND_TASK_CLEAR);
    }

    public boolean isAllowExecutionEnvironment(boolean setOverlayMessage) {
        class_2561 msg = null;
        if (BedrockMiner.gameMode.method_8386()) {
            msg = I18n.FAIL_MISSING_SURVIVAL;
        }
        if (BedrockMiner.client.field_1761 != null && !BedrockMiner.client.field_1761.method_2920().method_8388()) {
            msg = I18n.FAIL_MISSING_SURVIVAL;
        }
        if (InventoryManagerUtils.getInventoryItemCount(class_1802.field_8249) < 2) {
            msg = I18n.FAIL_MISSING_PISTON;
        }
        if (InventoryManagerUtils.getInventoryItemCount(class_1802.field_8530) < 1) {
            msg = I18n.FAIL_MISSING_REDSTONETORCH;
        }
        if (!InventoryManagerUtils.canInstantlyMinePiston()) {
            msg = I18n.FAIL_MISSING_INSTANTMINE;
        }
        if (msg != null && setOverlayMessage) {
            MessageUtils.setOverlayMessage(msg);
            return false;
        }
        return true;
    }

    @Override
    public void addBlockTask(class_638 world, class_2338 pos, class_2248 block) {
        if (ConfigManager.getInstance().getConfig().disable || !this.isWorking()) {
            return;
        }
        if (!this.isAllowExecutionEnvironment(true)) {
            return;
        }
        if (!BedrockMiner.gameMode.method_8388()) {
            return;
        }
        if (!ConfigManager.getInstance().getConfig().isAllowBlock(block)) {
            return;
        }
        if (ConfigManager.getInstance().getConfig().isFloorsBlacklist(pos)) {
            String msg = I18n.FLOOR_BLACK_LIST_WARN.getString().replace("(#floor#)", String.valueOf(pos.method_10264()));
            MessageUtils.setOverlayMessage((class_2561)class_2561.method_43470((String)msg));
            return;
        }
        for (Task targetBlock : this.pendingBlockTasks) {
            if (!targetBlock.pos.equals((Object)pos)) continue;
            return;
        }
        this.pendingBlockTasks.add(new Task(world, block, pos));
    }

    @Override
    public void removeBlockTask(class_638 world, class_2338 pos) {
        Iterator<Task> iterator = this.pendingBlockTasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (!task.pos.equals((Object)pos)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public void removeBlockTaskAll() {
        this.pendingBlockTasks.clear();
    }

    @Override
    public void addRegionTask(String name, class_638 world, class_2338 pos1, class_2338 pos2) {
        for (TaskRegion range : this.pendingRegionTasks) {
            if (!range.name.equals(name)) continue;
            return;
        }
        this.pendingRegionTasks.add(new TaskRegion(name, world, pos1, pos2));
    }

    @Override
    public void removeRegionTaskAll(String name) {
        Iterator<TaskRegion> iterator = this.pendingRegionTasks.iterator();
        while (iterator.hasNext()) {
            TaskRegion range = iterator.next();
            if (!range.name.equals(name)) continue;
            iterator.remove();
            return;
        }
    }

    @Override
    public void removeRegionTaskAll() {
        this.pendingRegionTasks.clear();
    }

    public void switchOnOff(@Nullable class_2248 block) {
        if (ConfigManager.getInstance().getConfig().disable || !ConfigManager.getInstance().getConfig().isAllowBlock(block)) {
            return;
        }
        this.switchOnOff();
    }

    @Override
    public void switchOnOff() {
        if (this.isWorking()) {
            this.clearTask();
            this.setWorking(false);
        } else {
            if (BedrockMiner.gameMode.method_8386()) {
                MessageUtils.addMessage(I18n.FAIL_MISSING_SURVIVAL);
                return;
            }
            this.setWorking(true);
            if (!BedrockMiner.client.method_1542()) {
                MessageUtils.addMessage(I18n.WARN_MULTIPLAYER);
            }
        }
    }

    @Override
    public void setWorking(boolean working) {
        if (working) {
            MessageUtils.addMessage(I18n.TOGGLE_ON);
        } else {
            MessageUtils.addMessage(I18n.TOGGLE_OFF);
        }
        this.working = working;
    }

    @Override
    public boolean isWorking() {
        return this.working;
    }

    @Override
    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    @Nullable
    public Task getCurrentTask() {
        return this.currentTask;
    }

    public ArrayList<Task> getPendingBlockTasks() {
        return this.pendingBlockTasks;
    }

    public List<TaskRegion> getPendingRegionTasks() {
        return this.pendingRegionTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TaskManager getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<TaskManager> clazz = TaskManager.class;
        synchronized (TaskManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new TaskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

