/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.task;

import com.github.bunnyi116.bedrockminer.config.ConfigManager;
import com.github.bunnyi116.bedrockminer.task.TaskPlan;
import com.github.bunnyi116.bedrockminer.task.TaskPlanItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2459;
import net.minecraft.class_2680;
import net.minecraft.class_638;

public class TaskPlanTools {
    public static List<TaskPlan> findAllPossible(class_2338 targetPos, class_638 world) {
        ArrayList<TaskPlan> schemes = new ArrayList<TaskPlan>();
        for (class_2350 direction : ConfigManager.getInstance().getConfig().pistonDirections) {
            TaskPlanItem[] pistons;
            for (TaskPlanItem piston : pistons = TaskPlanTools.findPistonPossible(direction, targetPos)) {
                TaskPlanItem[] redstoneTorches;
                for (TaskPlanItem redstoneTorch : redstoneTorches = TaskPlanTools.findRedstoneTorchPossible(direction, targetPos, piston)) {
                    TaskPlanItem slimeBlock = TaskPlanTools.findSlimeBlockPossible(redstoneTorch);
                    schemes.add(new TaskPlan(direction, piston, redstoneTorch, slimeBlock));
                }
            }
        }
        return schemes;
    }

    private static TaskPlanItem[] findPistonPossible(class_2350 direction, class_2338 targetPos) {
        ArrayList<TaskPlanItem> list = new ArrayList<TaskPlanItem>();
        class_2338 pistonPos = targetPos.method_10093(direction);
        for (class_2350 pistonFacing : ConfigManager.getInstance().getConfig().pistonFacings) {
            class_2338 pistonHeadPos = pistonPos.method_10093(pistonFacing);
            if (pistonHeadPos.equals((Object)targetPos)) continue;
            int level = switch (pistonFacing) {
                default -> throw new IncompatibleClassChangeError();
                case class_2350.field_11036 -> 0;
                case class_2350.field_11033 -> 1;
                case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> 2;
            };
            list.add(new TaskPlanItem(pistonPos, pistonFacing, level));
        }
        return (TaskPlanItem[])list.toArray(TaskPlanItem[]::new);
    }

    private static TaskPlanItem[] findRedstoneTorchPossible(class_2350 direction, class_2338 targetPos, TaskPlanItem pistonInfo) {
        ArrayList<TaskPlanItem> list = new ArrayList<TaskPlanItem>();
        class_2338 pistonHeadPos = pistonInfo.pos.method_10093(pistonInfo.facing);
        if (direction == class_2350.field_11036) {
            class_2338 redstoneTorchPos = targetPos.method_10093(direction.method_10153());
            class_2350[] class_2350Array = ConfigManager.getInstance().getConfig().redstoneTorchFacings;
            int n = class_2350Array.length;
            for (int i = 0; i < n; ++i) {
                class_2350 redstoneTorchFacing = class_2350Array[i];
                class_2338 basePos = redstoneTorchPos.method_10093(redstoneTorchFacing.method_10153());
                if (basePos.equals((Object)pistonInfo.pos) || basePos.equals((Object)pistonHeadPos) || redstoneTorchFacing == class_2350.field_11033) continue;
                int level = switch (redstoneTorchFacing) {
                    case class_2350.field_11036 -> 0;
                    case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> 2;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(redstoneTorchFacing));
                };
                list.add(new TaskPlanItem(1, redstoneTorchPos, redstoneTorchFacing, level));
            }
        }
        for (class_2350 redstoneTorchDirection : ConfigManager.getInstance().getConfig().redstoneTorchDirections) {
            class_2338 redstoneTorchPos = pistonInfo.pos.method_10093(redstoneTorchDirection);
            if (pistonHeadPos.equals((Object)redstoneTorchPos)) continue;
            for (class_2350 redstoneTorchFacing : ConfigManager.getInstance().getConfig().redstoneTorchFacings) {
                class_2338 baseUpPos;
                class_2338 redstoneTorchPosUp;
                class_2338 basePos = redstoneTorchPos.method_10093(redstoneTorchFacing.method_10153());
                if (basePos.equals((Object)pistonInfo.pos) || basePos.equals((Object)pistonHeadPos) || redstoneTorchFacing == class_2350.field_11033) continue;
                int level = switch (redstoneTorchFacing) {
                    case class_2350.field_11036 -> 0;
                    case class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034 -> 2;
                    default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(redstoneTorchFacing));
                };
                if (!redstoneTorchPos.equals((Object)targetPos)) {
                    list.add(new TaskPlanItem(redstoneTorchPos, redstoneTorchFacing, level));
                }
                if ((redstoneTorchPosUp = redstoneTorchPos.method_10084()).equals((Object)targetPos) || redstoneTorchPosUp.equals((Object)pistonInfo.pos) || (baseUpPos = redstoneTorchPos.method_10093(redstoneTorchFacing.method_10153())).equals((Object)pistonInfo.pos) || baseUpPos.equals((Object)pistonHeadPos)) continue;
                list.add(new TaskPlanItem(redstoneTorchPos.method_10084(), redstoneTorchFacing, level + 1));
            }
        }
        return (TaskPlanItem[])list.toArray(TaskPlanItem[]::new);
    }

    private static TaskPlanItem findSlimeBlockPossible(TaskPlanItem redstoneTorchInfo) {
        class_2338 pos = redstoneTorchInfo.pos;
        class_2350 facing = redstoneTorchInfo.facing;
        return new TaskPlanItem(pos.method_10093(facing.method_10153()), facing, facing.method_10166().method_10178() ? 0 : 1);
    }

    public static class_2338[] findPistonNearbyRedstoneTorch(class_2338 pistonPos, class_638 world) {
        ArrayList<class_2338> list = new ArrayList<class_2338>();
        int range = 3;
        for (class_2350 direction : class_2350.values()) {
            for (int i = 0; i < range; ++i) {
                class_2338 posDown;
                class_2680 posDownState;
                class_2338 posUp;
                class_2680 posUpState;
                class_2338 pos = pistonPos.method_10079(direction, i);
                class_2680 posState = world.method_8320(pos);
                if (posState.method_26204() instanceof class_2459) {
                    list.add(pos);
                }
                if ((posUpState = world.method_8320(posUp = pos.method_10084())).method_26204() instanceof class_2459) {
                    list.add(posUp);
                }
                if (!((posDownState = world.method_8320(posDown = pos.method_10074())).method_26204() instanceof class_2459)) continue;
                list.add(posDown);
            }
        }
        return (class_2338[])list.toArray(class_2338[]::new);
    }
}

