/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.util.player;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.util.block.BlockUtils;
import com.github.bunnyi116.bedrockminer.util.network.NetworkUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerInventoryUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerLookUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerUtils;
import java.util.ArrayDeque;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_3965;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class PlayerInteractionUtils {
    public static final float BREAKING_PROGRESS_MAX = 1.0f;
    private static class_2338 currentBreakingPos = new class_2338(-1, -1, -1);
    private static float currentBreakingProgress;
    private static boolean breakingBlock;
    private static int breakingTicks;
    private static int breakingTickMax;
    private static final Queue<class_2338> blockQueue;

    private static int getBlockBreakingProgress() {
        float breakingProgress = currentBreakingProgress >= 1.0f ? 1.0f : currentBreakingProgress;
        return breakingProgress > 0.0f ? (int)(breakingProgress * 10.0f) : -1;
    }

    public static boolean updateBlockBreakingProgress(class_2338 pos, class_2350 direction, boolean localPrediction) {
        if (!BedrockMiner.world.method_8621().method_11952(pos)) {
            return false;
        }
        if (BedrockMiner.player.method_21701((class_1937)BedrockMiner.world, pos, BedrockMiner.gameMode)) {
            return false;
        }
        if (!PlayerUtils.canInteractWithBlockAt(pos, 0.0)) {
            return false;
        }
        class_2680 blockState = BedrockMiner.world.method_8320(pos);
        if (BedrockMiner.gameMode.method_8386()) {
            PlayerInteractionUtils.setBreakingBlock(true);
            NetworkUtils.sendSequencedPacket(sequence -> {
                if (!blockState.method_26215() && localPrediction) {
                    BedrockMiner.interactionManager.method_2899(pos);
                }
                return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
            });
            PlayerInteractionUtils.setBreakingBlock(false);
            return true;
        }
        if (breakingBlock && pos.equals((Object)currentBreakingPos)) {
            if (blockState.method_26215()) {
                PlayerInteractionUtils.setBreakingBlock(false);
                return true;
            }
            if ((currentBreakingProgress += PlayerUtils.calcBlockBreakingDelta(blockState)) >= 1.0f) {
                NetworkUtils.sendSequencedPacket(sequence -> {
                    if (!blockState.method_26215() && localPrediction) {
                        BedrockMiner.interactionManager.method_2899(pos);
                    }
                    return new class_2846(class_2846.class_2847.field_12973, pos, direction, sequence);
                });
                currentBreakingProgress = 0.0f;
                BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), currentBreakingPos, -1);
                PlayerInteractionUtils.setBreakingBlock(false);
                return true;
            }
            BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), currentBreakingPos, PlayerInteractionUtils.getBlockBreakingProgress());
            ++breakingTickMax;
        } else {
            if (breakingBlock && !pos.equals((Object)currentBreakingPos)) {
                NetworkUtils.sendPacket(new class_2846(class_2846.class_2847.field_12971, currentBreakingPos, direction));
                PlayerInteractionUtils.setBreakingBlock(false);
            }
            if ((currentBreakingProgress += PlayerUtils.calcBlockBreakingDelta(blockState)) >= 1.0f) {
                PlayerInteractionUtils.setBreakingBlock(true);
                NetworkUtils.sendSequencedPacket(sequence -> {
                    if (!blockState.method_26215() && localPrediction) {
                        BedrockMiner.interactionManager.method_2899(pos);
                    }
                    return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
                });
                PlayerInteractionUtils.setBreakingBlock(false);
                return true;
            }
            NetworkUtils.sendSequencedPacket(sequence -> {
                if (!blockState.method_26215() && currentBreakingProgress == 0.0f) {
                    blockState.method_26179((class_1937)BedrockMiner.world, pos, (class_1657)BedrockMiner.player);
                }
                PlayerInteractionUtils.setBreakingBlock(true);
                currentBreakingPos = pos;
                currentBreakingProgress = 0.0f;
                BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), currentBreakingPos, PlayerInteractionUtils.getBlockBreakingProgress());
                return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
            });
        }
        return false;
    }

    public static void updateBlockBreakingProgress(class_2338 pos, class_2350 direction) {
        PlayerInteractionUtils.updateBlockBreakingProgress(pos, direction, true);
    }

    public static void updateBlockBreakingProgress(class_2338 pos, boolean localPrediction) {
        PlayerInteractionUtils.updateBlockBreakingProgress(pos, PlayerUtils.getClosestFace(pos), localPrediction);
    }

    public static void updateBlockBreakingProgress(class_2338 pos) {
        PlayerInteractionUtils.updateBlockBreakingProgress(pos, true);
    }

    public static void resetBreaking() {
        breakingTicks = 0;
        breakingTickMax = 20;
        PlayerInteractionUtils.setBreakingBlock(false);
    }

    public static void autoResetBreaking() {
        if (!breakingBlock && breakingTicks > 0) {
            PlayerInteractionUtils.resetBreaking();
        }
        if (breakingBlock && breakingTicks++ > breakingTickMax) {
            PlayerInteractionUtils.resetBreaking();
        }
    }

    public static boolean isBreakingBlock() {
        return breakingBlock;
    }

    public static void setBreakingBlock(boolean breakingBlock) {
        PlayerInteractionUtils.breakingBlock = breakingBlock;
    }

    public static void placement(class_2338 blockPos, class_2350 facing, class_1792 ... items) {
        if (blockPos == null || facing == null) {
            return;
        }
        if (!BlockUtils.isReplaceable(BedrockMiner.world.method_8320(blockPos))) {
            return;
        }
        if (!PlayerUtils.canInteractWithBlockAt(blockPos, 0.0)) {
            return;
        }
        if (items != null) {
            PlayerInventoryUtils.switchToItem(items);
        }
        if (facing.method_10166().method_10178()) {
            float yaw = switch (facing) {
                case class_2350.field_11035 -> 180.0f;
                case class_2350.field_11034 -> 90.0f;
                case class_2350.field_11043 -> 0.0f;
                case class_2350.field_11039 -> -90.0f;
                default -> BedrockMiner.player.method_36454();
            };
            float pitch = switch (facing) {
                case class_2350.field_11036 -> 90.0f;
                case class_2350.field_11033 -> -90.0f;
                default -> 0.0f;
            };
            PlayerLookUtils.sendLookPacket(BedrockMiner.networkHandler, yaw, pitch);
        }
        class_2338 hitPos = blockPos.method_10093(facing.method_10153());
        class_243 hitVec3d = class_243.method_24953((class_2382)hitPos).method_43206(facing, 0.5);
        class_3965 hitResult = new class_3965(hitVec3d, facing, blockPos, false);
        BedrockMiner.interactionManager.method_2896(BedrockMiner.player, class_1268.field_5808, hitResult);
    }

    public static void placement(class_2338 blockPos, class_2350 facing) {
        PlayerInteractionUtils.placement(blockPos, facing, new class_1792[]{null});
    }

    public static boolean canPlace(class_638 world, class_2338 blockPos, class_2680 placeBlockState) {
        if (!BlockUtils.isReplaceable(world.method_8320(blockPos))) {
            return false;
        }
        class_265 collisionShape = placeBlockState.method_26220((class_1922)world, blockPos);
        if (collisionShape.method_1110()) {
            return true;
        }
        for (class_1297 entity : world.method_18112()) {
            if (entity instanceof class_1542) {
                return true;
            }
            if (!entity.method_30632(blockPos, placeBlockState)) continue;
            return false;
        }
        return true;
    }

    static {
        blockQueue = new ArrayDeque<class_2338>();
    }
}

