/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.util;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.util.PlayerInventoryUtils;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_2868;
import net.minecraft.class_7202;
import net.minecraft.class_7204;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientPlayerInteractionManagerUtils {
    public static final float BREAKING_PROGRESS_MAX = 0.7f;
    private static class_2338 currentBreakingPos = new class_2338(-1, -1, -1);
    private static class_1799 selectedStack;
    private static float currentBreakingProgress;
    private static boolean breakingBlock;
    private static int lastSelectedSlot;
    private static int breakingTicks;
    private static int breakingTickMax;

    private static void syncSelectedSlot() {
        int i = PlayerInventoryUtils.getSelectedSlot();
        if (i != lastSelectedSlot) {
            lastSelectedSlot = i;
            BedrockMiner.networkHandler.method_2883((class_2596)new class_2868(lastSelectedSlot));
        }
    }

    private static boolean isCurrentlyBreaking(class_2338 pos) {
        class_1799 itemStack = BedrockMiner.player.method_6047();
        return pos.equals((Object)currentBreakingPos) && class_1799.method_31577((class_1799)itemStack, (class_1799)selectedStack);
    }

    private static int getBlockBreakingProgress() {
        return currentBreakingProgress > 0.0f ? (int)(currentBreakingProgress * 10.0f) : -1;
    }

    private static boolean attackBlock(class_2338 pos, class_2350 direction, @Nullable Runnable beforeBreaking, @Nullable Runnable afterBreaking) {
        if (BedrockMiner.player.method_21701((class_1937)BedrockMiner.world, pos, BedrockMiner.gameMode)) {
            return false;
        }
        if (!BedrockMiner.world.method_8621().method_11952(pos)) {
            return false;
        }
        if (BedrockMiner.gameMode.method_8386()) {
            breakingBlock = true;
            ClientPlayerInteractionManagerUtils.sendSequencedPacket(sequence -> {
                BedrockMiner.interactionManager.method_2899(pos);
                return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
            }, beforeBreaking, afterBreaking);
            breakingBlock = false;
        } else if (!breakingBlock || !ClientPlayerInteractionManagerUtils.isCurrentlyBreaking(pos)) {
            class_2680 blockState;
            float calcBlockBreakingDelta;
            if (breakingBlock) {
                BedrockMiner.networkHandler.method_2883((class_2596)new class_2846(class_2846.class_2847.field_12971, currentBreakingPos, direction));
                breakingBlock = false;
            }
            if ((calcBlockBreakingDelta = (blockState = BedrockMiner.world.method_8320(pos)).method_26165((class_1657)BedrockMiner.player, (class_1922)BedrockMiner.player.method_5770(), pos)) >= 0.7f) {
                breakingBlock = true;
                ClientPlayerInteractionManagerUtils.sendSequencedPacket(sequence -> {
                    if (!blockState.method_26215()) {
                        BedrockMiner.interactionManager.method_2899(pos);
                    }
                    return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
                }, beforeBreaking, afterBreaking);
                breakingBlock = false;
            } else {
                ClientPlayerInteractionManagerUtils.sendSequencedPacket(sequence -> {
                    if (!blockState.method_26215() && currentBreakingProgress == 0.0f) {
                        blockState.method_26179((class_1937)BedrockMiner.world, pos, (class_1657)BedrockMiner.player);
                    }
                    breakingBlock = true;
                    currentBreakingPos = pos;
                    selectedStack = BedrockMiner.player.method_6047();
                    currentBreakingProgress = 0.0f;
                    BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), currentBreakingPos, ClientPlayerInteractionManagerUtils.getBlockBreakingProgress());
                    return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
                });
            }
        }
        ++breakingTickMax;
        return true;
    }

    public static boolean updateBlockBreakingProgress(class_2338 pos, class_2350 direction, @Nullable Runnable beforeBreaking, @Nullable Runnable afterBreaking) {
        ClientPlayerInteractionManagerUtils.syncSelectedSlot();
        if (BedrockMiner.gameMode.method_8386() && BedrockMiner.world.method_8621().method_11952(pos)) {
            breakingBlock = true;
            ClientPlayerInteractionManagerUtils.sendSequencedPacket(sequence -> {
                BedrockMiner.interactionManager.method_2899(pos);
                return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
            }, beforeBreaking, afterBreaking);
            breakingBlock = false;
            ++breakingTickMax;
            return true;
        }
        if (breakingBlock && ClientPlayerInteractionManagerUtils.isCurrentlyBreaking(pos)) {
            class_2680 blockState = BedrockMiner.world.method_8320(pos);
            if (blockState.method_26215()) {
                breakingBlock = false;
                return false;
            }
            breakingBlock = true;
            if ((currentBreakingProgress += blockState.method_26165((class_1657)BedrockMiner.player, (class_1922)BedrockMiner.player.method_5770(), pos)) >= 0.7f) {
                ClientPlayerInteractionManagerUtils.sendSequencedPacket(sequence -> {
                    BedrockMiner.interactionManager.method_2899(pos);
                    return new class_2846(class_2846.class_2847.field_12973, pos, direction, sequence);
                }, beforeBreaking, afterBreaking);
                currentBreakingProgress = 0.0f;
                breakingBlock = false;
            }
            BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), currentBreakingPos, ClientPlayerInteractionManagerUtils.getBlockBreakingProgress());
            ++breakingTickMax;
            return true;
        }
        return ClientPlayerInteractionManagerUtils.attackBlock(pos, direction, beforeBreaking, afterBreaking);
    }

    public static void updateBlockBreakingProgress(class_2338 pos) {
        ClientPlayerInteractionManagerUtils.updateBlockBreakingProgress(pos, ClientPlayerInteractionManagerUtils.getClosestFace(pos), null, null);
    }

    public static void sendSequencedPacket(class_7204 packetCreator, @Nullable Runnable beforeSending, @Nullable Runnable afterSending) {
        try (class_7202 pendingUpdateManager = BedrockMiner.world.method_41925().method_41937();){
            int i = pendingUpdateManager.method_41942();
            class_2596 packet = packetCreator.predict(i);
            if (beforeSending != null) {
                beforeSending.run();
            }
            BedrockMiner.networkHandler.method_2883(packet);
            if (afterSending != null) {
                afterSending.run();
            }
        }
    }

    public static void sendSequencedPacket(class_7204 packetCreator) {
        ClientPlayerInteractionManagerUtils.sendSequencedPacket(packetCreator, null, null);
    }

    public static class_2350 getClosestFace(class_2338 targetPos) {
        class_243 playerPos = BedrockMiner.player.method_33571();
        class_243 targetCenterPos = class_243.method_24953((class_2382)targetPos);
        class_2350 closestFace = null;
        double closestDistanceSquared = Double.MAX_VALUE;
        for (class_2350 direction : class_2350.values()) {
            double offsetZ;
            double offsetY;
            double offsetX = (double)direction.method_10148() * 0.5;
            class_243 facePos = targetCenterPos.method_1031(offsetX, offsetY = (double)direction.method_10164() * 0.5, offsetZ = (double)direction.method_10165() * 0.5);
            double distanceSquared = playerPos.method_1025(facePos);
            if (!(distanceSquared < closestDistanceSquared)) continue;
            closestDistanceSquared = distanceSquared;
            closestFace = direction;
        }
        return closestFace;
    }

    private static List<class_243> getFacePoints(class_243 center, class_2350 side) {
        ArrayList<class_243> points = new ArrayList<class_243>();
        double halfSize = 0.5;
        double offsetX = (double)side.method_10148() * halfSize;
        double offsetY = (double)side.method_10164() * halfSize;
        double offsetZ = (double)side.method_10165() * halfSize;
        class_243 faceCenter = center.method_1031(offsetX, offsetY, offsetZ);
        points.add(faceCenter);
        if (side.method_10166() == class_2350.class_2351.field_11052) {
            points.add(faceCenter.method_1031(halfSize, 0.0, halfSize));
            points.add(faceCenter.method_1031(halfSize, 0.0, -halfSize));
            points.add(faceCenter.method_1031(-halfSize, 0.0, halfSize));
            points.add(faceCenter.method_1031(-halfSize, 0.0, -halfSize));
        } else if (side.method_10166() == class_2350.class_2351.field_11048) {
            points.add(faceCenter.method_1031(0.0, halfSize, halfSize));
            points.add(faceCenter.method_1031(0.0, halfSize, -halfSize));
            points.add(faceCenter.method_1031(0.0, -halfSize, halfSize));
            points.add(faceCenter.method_1031(0.0, -halfSize, -halfSize));
        } else if (side.method_10166() == class_2350.class_2351.field_11051) {
            points.add(faceCenter.method_1031(halfSize, halfSize, 0.0));
            points.add(faceCenter.method_1031(halfSize, -halfSize, 0.0));
            points.add(faceCenter.method_1031(-halfSize, halfSize, 0.0));
            points.add(faceCenter.method_1031(-halfSize, -halfSize, 0.0));
        }
        return points;
    }

    public static void resetBreaking() {
        breakingTicks = 0;
        breakingTickMax = 200;
        breakingBlock = false;
    }

    public static void autoResetBreaking() {
        if (!breakingBlock && breakingTicks > 0) {
            ClientPlayerInteractionManagerUtils.resetBreaking();
        }
        if (breakingBlock && breakingTicks++ > breakingTickMax) {
            ClientPlayerInteractionManagerUtils.resetBreaking();
        }
    }

    public static boolean isBreakingBlock() {
        return breakingBlock;
    }
}

