/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.util;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.util.network.NetworkUtils;
import com.github.bunnyi116.bedrockminer.util.player.PlayerUtils;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ClientPlayerInteractionManagerUtils {
    public static final float BREAKING_PROGRESS_MAX = 0.7f;
    private static boolean breakingBlock;
    private static int breakingTicks;
    private static int breakingTickMax;

    public static boolean attackBlock(class_2338 pos, class_2350 direction, @Nullable Runnable beforeBreaking, @Nullable Runnable afterBreaking) {
        BedrockMiner.interactionManager.method_2911();
        if (BedrockMiner.player.method_21701((class_1937)BedrockMiner.world, pos, BedrockMiner.gameMode)) {
            return false;
        }
        if (!BedrockMiner.world.method_8621().method_11952(pos)) {
            return false;
        }
        if (BedrockMiner.gameMode.method_8386()) {
            ClientPlayerInteractionManagerUtils.setBreakingBlock(true);
            NetworkUtils.sendSequencedPacket(sequence -> {
                BedrockMiner.interactionManager.method_2899(pos);
                return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
            }, beforeBreaking, afterBreaking);
            ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
        } else if (!breakingBlock && !BedrockMiner.interactionManager.field_3717 || !BedrockMiner.interactionManager.method_2922(pos)) {
            class_2680 blockState;
            float calcBlockBreakingDelta;
            if (breakingBlock || BedrockMiner.interactionManager.field_3717) {
                BedrockMiner.networkHandler.method_2883((class_2596)new class_2846(class_2846.class_2847.field_12971, BedrockMiner.interactionManager.field_3714, direction));
                ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
            }
            if ((calcBlockBreakingDelta = PlayerUtils.calcBlockBreakingDelta(blockState = BedrockMiner.world.method_8320(pos))) >= 0.7f) {
                ClientPlayerInteractionManagerUtils.setBreakingBlock(true);
                NetworkUtils.sendSequencedPacket(sequence -> {
                    if (!blockState.method_26215()) {
                        BedrockMiner.interactionManager.method_2899(pos);
                    }
                    return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
                }, beforeBreaking, afterBreaking);
                ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
            } else {
                NetworkUtils.sendSequencedPacket(sequence -> {
                    if (!blockState.method_26215() && BedrockMiner.interactionManager.field_3715 == 0.0f) {
                        blockState.method_26179((class_1937)BedrockMiner.world, pos, (class_1657)BedrockMiner.player);
                    }
                    ClientPlayerInteractionManagerUtils.setBreakingBlock(true);
                    BedrockMiner.interactionManager.field_3714 = pos;
                    BedrockMiner.interactionManager.field_3718 = BedrockMiner.player.method_6047();
                    BedrockMiner.interactionManager.field_3715 = 0.0f;
                    BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), BedrockMiner.interactionManager.field_3714, ClientPlayerInteractionManagerUtils.getBlockBreakingProgress());
                    return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
                });
            }
        }
        ++breakingTickMax;
        return true;
    }

    public static boolean attackBlock(class_2338 pos) {
        return ClientPlayerInteractionManagerUtils.attackBlock(pos, PlayerUtils.getClosestFace(pos), null, null);
    }

    public static boolean updateBlockBreakingProgress(class_2338 pos, class_2350 direction, @Nullable Runnable beforeBreaking, @Nullable Runnable afterBreaking) {
        BedrockMiner.interactionManager.method_2911();
        if (BedrockMiner.gameMode.method_8386() && BedrockMiner.world.method_8621().method_11952(pos)) {
            ClientPlayerInteractionManagerUtils.setBreakingBlock(true);
            NetworkUtils.sendSequencedPacket(sequence -> {
                BedrockMiner.interactionManager.method_2899(pos);
                return new class_2846(class_2846.class_2847.field_12968, pos, direction, sequence);
            }, beforeBreaking, afterBreaking);
            ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
            ++breakingTickMax;
            return true;
        }
        if ((breakingBlock || BedrockMiner.interactionManager.field_3717) && BedrockMiner.interactionManager.method_2922(pos)) {
            class_2680 blockState = BedrockMiner.world.method_8320(pos);
            if (blockState.method_26215()) {
                ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
                return false;
            }
            ClientPlayerInteractionManagerUtils.setBreakingBlock(true);
            BedrockMiner.interactionManager.field_3715 += PlayerUtils.calcBlockBreakingDelta(blockState);
            if (BedrockMiner.interactionManager.field_3715 >= 0.7f) {
                NetworkUtils.sendSequencedPacket(sequence -> {
                    BedrockMiner.interactionManager.method_2899(pos);
                    return new class_2846(class_2846.class_2847.field_12973, pos, direction, sequence);
                }, beforeBreaking, afterBreaking);
                BedrockMiner.interactionManager.field_3715 = 0.0f;
                ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
            }
            BedrockMiner.world.method_8517(BedrockMiner.player.method_5628(), BedrockMiner.interactionManager.field_3714, ClientPlayerInteractionManagerUtils.getBlockBreakingProgress());
            ++breakingTickMax;
            return true;
        }
        return ClientPlayerInteractionManagerUtils.attackBlock(pos, direction, beforeBreaking, afterBreaking);
    }

    public static void updateBlockBreakingProgress(class_2338 pos) {
        ClientPlayerInteractionManagerUtils.updateBlockBreakingProgress(pos, PlayerUtils.getClosestFace(pos), null, null);
    }

    public static int getBlockBreakingProgress() {
        return BedrockMiner.interactionManager.field_3715 > 0.0f ? (int)(BedrockMiner.interactionManager.field_3715 * 10.0f) : -1;
    }

    public static void resetBreaking() {
        breakingTicks = 0;
        breakingTickMax = 200;
        ClientPlayerInteractionManagerUtils.setBreakingBlock(false);
    }

    public static void autoResetBreaking() {
        if (!breakingBlock && breakingTicks > 0) {
            ClientPlayerInteractionManagerUtils.resetBreaking();
        }
        if (breakingBlock && breakingTicks++ > breakingTickMax) {
            ClientPlayerInteractionManagerUtils.resetBreaking();
        }
    }

    public static boolean isBreakingBlock() {
        return breakingBlock;
    }

    public static void setBreakingBlock(boolean breakingBlock) {
        ClientPlayerInteractionManagerUtils.breakingBlock = breakingBlock;
        BedrockMiner.interactionManager.field_3717 = breakingBlock;
    }
}

