/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.command.argument;

import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.util.StringReaderUtils;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class BlockArgument
implements ArgumentType<class_2248> {
    private static final DynamicCommandExceptionType INVALID_STRING_EXCEPTION = new DynamicCommandExceptionType(input -> class_2561.method_43470((String)I18n.COMMAND_EXCEPTION_INVALID_STRING.getString().replace("#input#", input.toString())));
    private static final Collection<String> EXAMPLES = Arrays.asList("Stone", "Bedrock", "\u77f3\u5934", "\u57fa\u5ca9");
    @Nullable
    private Predicate<class_2248> filter;

    public BlockArgument(@Nullable Predicate<class_2248> filter) {
        this.filter = filter;
    }

    public BlockArgument() {
        this(null);
    }

    public static class_2248 getBlock(CommandContext<FabricClientCommandSource> context, String name) {
        return (class_2248)context.getArgument(name, class_2248.class);
    }

    public class_2248 parse(StringReader reader) throws CommandSyntaxException {
        String input = StringReaderUtils.readUnquotedString(reader);
        class_2248 blockResult = null;
        for (class_2248 block : class_2378.field_11146) {
            if (!block.method_9518().getString().equals(input)) continue;
            blockResult = block;
            break;
        }
        if (blockResult != null && this.filter != null && this.filter.test(blockResult)) {
            blockResult = null;
        }
        if (blockResult == null) {
            throw INVALID_STRING_EXCEPTION.create((Object)input);
        }
        return blockResult;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        String input = StringReaderUtils.readUnquotedString(reader);
        for (class_2248 block : class_2378.field_11146) {
            String blockName = block.method_9518().getString();
            if (!blockName.contains(input) || this.filter != null && this.filter.test(block)) continue;
            builder.suggest(blockName);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public BlockArgument setFilter(Predicate<class_2248> filter) {
        this.filter = filter;
        return this;
    }
}

