/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.command.argument.operator;

import com.github.bunnyi116.bedrockminer.I18n;
import com.github.bunnyi116.bedrockminer.command.argument.operator.Operator;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;

public class OperatorArgument
implements ArgumentType<Operator> {
    private static final DynamicCommandExceptionType INVALID_STRING_EXCEPTION = new DynamicCommandExceptionType(input -> class_2561.method_43470((String)I18n.COMMAND_EXCEPTION_INVALID_STRING.getString().replace("%input%", input.toString())));
    private static final Collection<String> EXAMPLES = Arrays.asList(">", ">=", "==", "<=", "<");

    public static Operator getOperator(CommandContext<FabricClientCommandSource> context, String name) {
        return (Operator)((Object)context.getArgument(name, Operator.class));
    }

    public Operator parse(StringReader reader) throws CommandSyntaxException {
        String input = reader.readUnquotedString();
        Operator operatorType = Operator.fromString(input);
        if (operatorType == null) {
            throw INVALID_STRING_EXCEPTION.create((Object)input);
        }
        return operatorType;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        String input = this.readUnquotedString(reader);
        for (String operatorString : Operator.getStringValues()) {
            if (!operatorString.contains(input)) continue;
            builder.suggest(operatorString);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public String readUnquotedString(StringReader reader) {
        int start = reader.getCursor();
        while (reader.canRead()) {
            reader.skip();
        }
        return reader.getString().substring(start, reader.getCursor());
    }
}

