/*
 * Decompiled with CFR 0.152.
 */
package com.github.bunnyi116.bedrockminer.mixin;

import com.github.bunnyi116.bedrockminer.BedrockMiner;
import com.github.bunnyi116.bedrockminer.task.TaskManager;
import com.github.bunnyi116.bedrockminer.util.player.PlayerInteractionUtils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_636.class}, priority=999)
public abstract class MixinClientPlayerInteractionManager {
    @Unique
    private int interactBlockCooldown = 0;

    @Inject(at={@At(value="HEAD")}, method={"method_2910(Lnet/minecraft/class_2338;Lnet/minecraft/class_2350;)Z"}, cancellable=true)
    private void attackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        class_2680 blockState = BedrockMiner.world.method_8320(pos);
        class_2248 block = blockState.method_26204();
        if (TaskManager.getInstance().isBedrockMinerFeatureEnable()) {
            TaskManager.getInstance().addBlockTask(BedrockMiner.world, pos, block);
        }
        if (PlayerInteractionUtils.isBreakingBlock()) {
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_2925()V"}, cancellable=true)
    public void cancelBlockBreaking(CallbackInfo ci) {
        if (PlayerInteractionUtils.isBreakingBlock()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_2896(Lnet/minecraft/class_746;Lnet/minecraft/class_1268;Lnet/minecraft/class_3965;)Lnet/minecraft/class_1269;"}, cancellable=true)
    private void interactBlock(class_746 player, class_1268 hand, class_3965 blockHitResult, CallbackInfoReturnable<class_1269> cir) {
        if (this.interactBlockCooldown > 0) {
            --this.interactBlockCooldown;
        } else {
            this.interactBlockCooldown = 1;
            class_2338 blockPos = blockHitResult.method_17777();
            class_2680 blockState = BedrockMiner.world.method_8320(blockPos);
            class_2248 block = blockState.method_26204();
            if (TaskManager.getInstance().isBedrockMinerFeatureEnable() && player.method_6047().method_7960()) {
                TaskManager.getInstance().switchToggle(block);
            }
        }
        if (PlayerInteractionUtils.isBreakingBlock()) {
            cir.setReturnValue((Object)class_1269.field_5814);
            cir.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_2927()V"}, cancellable=true)
    public void tick(CallbackInfo ci) {
        this.updateGameVariable();
        if (PlayerInteractionUtils.isBreakingBlock()) {
            ci.cancel();
        }
        TaskManager.getInstance().tick();
        PlayerInteractionUtils.autoResetBreaking();
    }

    @Unique
    private void updateGameVariable() {
        BedrockMiner.client = class_310.method_1551();
        BedrockMiner.world = BedrockMiner.client.field_1687;
        BedrockMiner.player = BedrockMiner.client.field_1724;
        if (BedrockMiner.player != null) {
            BedrockMiner.playerInventory = BedrockMiner.player.method_31548();
        }
        BedrockMiner.crosshairTarget = BedrockMiner.client.field_1765;
        BedrockMiner.interactionManager = BedrockMiner.client.field_1761;
        BedrockMiner.networkHandler = BedrockMiner.client.method_1562();
        if (BedrockMiner.interactionManager != null) {
            BedrockMiner.gameMode = BedrockMiner.interactionManager.method_2920();
        }
    }
}

